package com.xdja.multichip.process.vhsm.net;

import android.content.Context;
import android.content.Intent;
import android.os.Environment;
import android.os.FileObserver;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;

import java.io.File;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2019/5/24 <br/>
 */
public class NetVhsmFileListener {

    private static final String TAG = "NetVhsmFileListenerTag";
    private static NetVhsmFileListener instance;

    static final String RANDFILEPATH = new File(Environment.getExternalStorageDirectory(), NetVhsmChipForCall.RANDFILEPATH).getAbsolutePath();
    static final String WBOXFILEPATH = new File(Environment.getExternalStorageDirectory(), NetVhsmChipForCall.WBOXFILEPATH).getAbsolutePath();
    static final String VHSMLIBFILEPATH = new File(Environment.getExternalStorageDirectory(), NetVhsmChipForCall.VHSMLIBFILEPATH).getAbsolutePath();

    private PriNetVhsmFileListener randListener;
    private PriNetVhsmFileListener wboxListener;
    private PriNetVhsmFileListener vhsmLibListener;
    private Context context;

    public static NetVhsmFileListener getInstance() {
        if (instance == null) {
            synchronized (NetVhsmFileListener.class) {
                if (instance == null) {
                    instance = new NetVhsmFileListener();
                }
            }
        }
        return instance;
    }

    private NetVhsmFileListener() {
        if (randListener == null) {
            randListener = new PriNetVhsmFileListener(RANDFILEPATH);
        }
        if (wboxListener == null) {
            wboxListener = new PriNetVhsmFileListener(WBOXFILEPATH);
        }
        if (vhsmLibListener == null) {
            vhsmLibListener = new PriNetVhsmFileListener(VHSMLIBFILEPATH);
        }
    }


    public void startObserver(Context context) {
        this.context = context;
        randListener.startWatching();
        wboxListener.startWatching();
        vhsmLibListener.startWatching();
    }


    private static final int FLAG_NOT_CHANGE = 0;
    private static final int FLAG_CHANGE = 1;
    private static int wboxChangeFlag = FLAG_NOT_CHANGE;

    static void setWboxChange() {
        wboxChangeFlag = FLAG_CHANGE;
    }

    static int getWboxChangeFlag() {
        return wboxChangeFlag;
    }

    static void setWboxNotChange() {
        wboxChangeFlag = FLAG_NOT_CHANGE;
    }

    class PriNetVhsmFileListener extends FileObserver {

        private String path;
        private int startWatchFlag = 0;

        public PriNetVhsmFileListener(String path) {
            super(path);
            this.path = path;
        }

        @Override
        public void onEvent(final int event, String path) {

            if (event == FileObserver.MODIFY) {
                SystemClock.sleep(100);
                if (getWboxChangeFlag() == FLAG_NOT_CHANGE) {
                    killSelf(context,event, this.path);
                } else {
                    setWboxNotChange();
                }
            } else if (event == FileObserver.DELETE || event == FileObserver.DELETE_SELF) {
                killSelf(context,event, this.path);
            }
        }

        @Override
        public void startWatching() {
            File file = new File(path);
            if (file.exists()) {
                if (startWatchFlag == 0) {
                    startWatchFlag = 1;
                    super.startWatching();
                }
            } else {
                if (startWatchFlag == 1) {
                    stopWatching();
                }
            }
        }

        @Override
        public void stopWatching() {
            startWatchFlag = 0;
            super.stopWatching();
        }
    }

    private static void killSelf(Context context, int event, String path) {
        Log.e(TAG, "killSelf event = " + event + " path = " + path);
        Intent intent = new Intent();
        intent.setClass(context, NetVhsmService.class);
        context.startService(intent);
        Process.killProcess(Process.myPid());
    }

}
