package com.xdja.multichip.process.vhsm.net;

import static com.xdja.multichip.jniapi.JarMultiJniApiErrorCode.RET_EXCEPTION;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Parcel;
import android.os.RemoteException;
import android.util.Log;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.multichip.MultiJniApiConfig;
import com.xdja.multichip.jniapi.JarMultiJniApiErrorCode;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.param.ParamKeywords;
import com.xdja.multichip.process.SuperJniApiBinder;
import com.xdja.multichip.utils.ChipLog;
import com.xdja.multichip.utils.FuncUtils;
import com.xdja.vhsm.base.VHSMBase;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/11/15 <br/>
 */
public class NetVhsmJniapiBinder extends SuperJniApiBinder {
    private NetVhsmJniApi jniApi;

    private static final String TAG = "netVhsmTag";

    private static NetVhsmJniapiBinder instance;

    private NetVhsmJniapiBinder(Context context) {
        super(context);
        if (jniApi == null) {
            jniApi = new NetVhsmJniApi(context);
        }
        registerReceiver();
    }

    public static NetVhsmJniapiBinder getInstance(Context context) {
        if (instance == null) {
            synchronized (NetVhsmJniapiBinder.class) {
                if (instance == null) {
                    instance = new NetVhsmJniapiBinder(context);
                }
            }
        }
        return instance;
    }

    @Override
    protected JNIAPI getApi() {
        return getNetVHSMJniApi();
    }


    protected NetVhsmJniApi getNetVHSMJniApi() {
        return jniApi;
    }

    @Override
    protected int selfOpenDev() {
        ChipLog.e(TAG,"start selfOpenDev ","selfOpenDev");
        int ret;
        mHandle = 0;

        int[] devNum = new int[1];
        ret = getApi().EnumDev(0, devNum);
        if (ret != 0) {
            return ret;
        }
        if (devNum[0] <= 0) {
            return JNIAPI.XKR_NO_KEY;
        }

        long[] handle = new long[1];
        ret = getApi().OpenDev(0, handle);
        if (ret == 0) {
            mHandle = handle[0];
            NetVhsmFileListener.getInstance().startObserver(mContext);
        }
        ChipLog.e(TAG,"end selfOpenDev "+ret,"selfOpenDev");
        return ret;
    }

    @Override
    public JniApiParam getJniApiParam() {
        // add by zhangxiaolong 2022-5-17
        // 在这里加入的目的是 防止已经配置了 进程不可用，但进程启动了，又调到这里，导致触发寻找芯片
        if (!MultiJniApiConfig.getInstance(mContext).judgeChipCanUse(NetVhsmChipForCall.NAME_PROCESS_NETVHSM)) {
            return null;
        }

        JniApiParam jniApiParam = super.getJniApiParam();
        if (jniApiParam != null) {
            boolean flag = FuncUtils.isLetterDigit(jniApiParam.cardId);
            if (!flag) {
                jniApiParam = null;
                closeDev();
            }
        }
        return jniApiParam;
    }

    @Override
    protected int getChipType() {
        return JniApiParam.TYPE_VHSM_NET;
    }

    public void closeDev() {
        getApi().CloseDev(mHandle);
        mHandle = 0;
    }

    @Override
    public Bundle callMethod(Bundle bundle) throws RemoteException {
        if (bundle == null) {
            return null;
        }
        if (bundle.containsKey(ParamKeywords.KEY_String_method)) {
            String method = bundle.getString(ParamKeywords.KEY_String_method);
            if (ParamKeywords.KEY_METHOD_UnlockPinUseUsn.equals(method)) {
                return super.callMethod(bundle);
            } else if ("SM4".equals(method)) {
                return SM4(bundle);
            } else if ("SetCardChangeListener".equals(method)) {
                // TODO: 2019/5/20
//                return setCardChangeListener(bundle);
                return null;
            } else if (ParamKeywords.KEY_METHOD_clearContainer.equals(method)) {
                // TODO: 2019/5/20
                return super.callMethod(bundle);
                /*Bundle result = super.callMethod(bundle);
                if (result.getInt(ParamKeywords.KEY_int_ret) == 0) {
                    CCCacheManager.getInstance().clear();
                }
                return result;*/
            }
        }
        return super.callMethod(bundle);
    }


    private Bundle SM4(Bundle bundle) {
        Bundle result = new Bundle();
        byte[] dataIn = bundle.getByteArray("dataIn");
        int dataLen = bundle.getInt("dataLen");
        int flag = bundle.getInt("flag");
        byte kID = bundle.getByte("kID");
        byte[] IV = bundle.getByteArray("IV");

        byte[] dataOut = new byte[dataLen];

        //modify 2018年4月2日19:40:45 weizg
        // getCCJniApi有可能返回null
        int ret = RET_EXCEPTION;

        try {

            ret = getNetVHSMJniApi().SM4(mHandle, dataIn, dataLen, flag, dataOut, kID, IV);

            if (isDevOnline(ret)) {
                ret = getNetVHSMJniApi().SM4(mHandle, dataIn, dataLen, flag, dataOut, kID, IV);
            }
        } catch (Exception e) {
            e.printStackTrace();
            ret = RET_EXCEPTION;
        }
        result.putInt("ret", ret);
        result.putByteArray("dataOut", dataOut);
        result.putByteArray("IV", IV);

        return result;
    }

    @Override
    protected boolean isDevOnline(int errCode) throws RemoteException {
        if(errCode!=0){
            ChipLog.e(TAG, "netvhsm isDevOnline errcode " + errCode,"isDevOnline");
        }
        if (errCode == JNIAPI.XKR_NO_HANDLE
                || errCode == VHSMBase.VHSM_RET_DEV_NOT_FOUND
                || errCode == VHSMBase.VHSM_RET_INVALID_PARA
                || errCode == VHSMBase.VHSM_RET_DEV_TYPE) {
            selfOpenDev();
            if (mHandle == 0) {
                return false;
            }
            return true;
        }
        return false;
    }


    /**
     * 此binder不可用的标志。
     * 主要用于当虚拟卡创建成功后，虚拟卡文件又被删除了情况
     */
    int unableFlag = 0;

    private static final int FLAG_UNABLE = -1;

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (unableFlag == FLAG_UNABLE) {
            reply.writeNoException();
            reply.writeInt(JarMultiJniApiErrorCode.RET_GET_BINDER_FAIL);
            notifyClientProxyDeath();
            return true;
        }
        return super.onTransact(code, data, reply, flags);
    }

    private static final String VHSM_ACTION = "com.xdja.vhsm.action";

    /**
     * 注册监听广播
     */
    private void registerReceiver() {
        final BroadcastReceiver receiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                int result = intent.getIntExtra("Result", -1);
                long time = intent.getLongExtra("Time", -1);

                Log.e(TAG, action + " " + result + " " + time);
                closeDev();
            }
        };
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(VHSM_ACTION);
        mContext.registerReceiver(receiver, intentFilter);
    }
}
