package com.xdja.uniteauth;

import android.os.IBinder;
import android.os.RemoteException;

import com.xdja.uniteauth.jar.IRealCallback;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/8/1 <br/>
 */
public class RealCallbackServer {

    private IBinder binder;
    private IRealCallback callBackBinder;

    public RealCallbackServer(final IBinder binder) {
        this.binder = binder;
        try {
            this.binder.linkToDeath(new IBinder.DeathRecipient() {
                @Override
                public void binderDied() {
                    RealCallbackServer.this.binder = null;
                    callBackBinder = null;
                }
            }, 0);
        } catch (RemoteException e) {
            e.printStackTrace();
        }
        callBackBinder = IRealCallback.Stub.asInterface(binder);
    }

    /**
     * 反调
     * @param random
     * @param ret
     * @param authCode
     * @param extra
     */
    public void callback(String random,int ret, String authCode, String extra){
        try {
            if (callBackBinder != null){
                callBackBinder.callback(random,ret,authCode,extra);
            }
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

}
