package com.xdja.uniteauth;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.text.TextUtils;

import com.xdja.uniteauth.jar.ErrorCode;
import com.xdja.uniteauth.jar.IUniteAuth;
import com.xdja.uniteauth.jar.ParamKeywords;
import com.xdja.uniteauth.presenter.AuthLoginActivity;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/7/31 <br/>
 */
public class UniteAuthBinder extends IUniteAuth.Stub {
    private static final String TAG = "UniteAuthBinderTag";

    private static UniteAuthBinder instance;
    private Context context;

    private UniteAuthBinder(Context context) {
        this.context = context;
    }

    public static UniteAuthBinder getInstance(Context context) {
        if (instance == null) {
            synchronized (UniteAuthBinder.class) {
                if (instance == null) {
                    instance = new UniteAuthBinder(context);
                }
            }
        }
        return instance;
    }


    @Override
    public Bundle call(Bundle bundle) throws RemoteException {
        if (bundle == null) {
            return null;
        }
        String method = bundle.getString(ParamKeywords.KEY_METHOD);
        if (TextUtils.isEmpty(method)) {
            return getBundleForNoSuchMethod();
        }

        if (method.equals(ParamKeywords.KEY_METHOD_getAuthCode)) {
            return getAuthCode(bundle);
        }
        return getBundleForNoSuchMethod();
    }

    /**
     * 得到没有此方法的Bundle
     *
     * @return
     */
    private Bundle getBundleForNoSuchMethod() {
        Bundle result = new Bundle();
        result.putInt(ParamKeywords.KEY_int_ret, ErrorCode.RET_NO_SUCH_METHOD);
        return result;
    }

    /**
     * 获取验证码
     *
     * @param bundle
     * @return
     */
    private Bundle getAuthCode(Bundle bundle) {
        int uid = getCallingUid();
        int pid = getCallingPid();

        String pkgName = PkgInfoCache.getInstance().getPkgName(uid, pid);
        if (TextUtils.isEmpty(pkgName)) {
            Bundle result = new Bundle();
            result.putInt(ParamKeywords.KEY_int_ret, ErrorCode.RET_NO_POWER);
            return result;
        }

        bundle.putInt(ParamKeywords.KEY_int_uid, uid);
        bundle.putInt(ParamKeywords.KEY_int_pid, pid);
        bundle.putString(ParamKeywords.KEY_String_pkgName, pkgName);

        Message msg = Message.obtain();
        msg.what = MSG_START_ACTIVITY;
        msg.obj = bundle;
        getHandler().sendMessage(msg);

        Bundle result = new Bundle();
        result.putInt(ParamKeywords.KEY_int_ret, 0);
        return result;
    }

    private final static int MSG_START_ACTIVITY = 1;
    Handler handler;

    private synchronized Handler getHandler() {
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper()) {
                @Override
                public void handleMessage(Message msg) {
                    super.handleMessage(msg);
                    if (msg.what == MSG_START_ACTIVITY) {
                        Intent intent = new Intent();
                        intent.setClass(context, AuthLoginActivity.class);
                        intent.putExtra(ParamKeywords.KEY_Bundle_bundle, (Bundle) msg.obj);
                        intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_NEW_TASK);
                        context.startActivity(intent);
                    }
                }
            };
        }

        return handler;
    }
}
