package com.xdja.uniteauth;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;

import com.xdja.uniteauth.jar.ErrorCode;
import com.xdja.uniteauth.jar.ParamKeywords;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/7/31 <br/>
 */
public class UniteAuthProvider extends ContentProvider {
    @Override
    public boolean onCreate() {
        ApplicationContext.setContext(getContext());
        return false;
    }

    @Override
    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }

    @Override
    public String getType(Uri uri) {
        return null;
    }

    @Override
    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    @Override
    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    @Override
    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }

    @Override
    public Bundle call(String method, String arg, Bundle extras) {
        if (TextUtils.isEmpty(method) || TextUtils.isEmpty(arg) || extras == null) {
            return null;
        }

        int uid = Binder.getCallingUid();
        int pid = Binder.getCallingPid();
        String pkgName = getCallingPackage();

        PkgInfoCache.getInstance().setPkgName(uid,pid,pkgName);

        //先判断调用过来的jar包的版本，看是否支持
        int version = extras.getInt(ParamKeywords.KEY_int_version);
        if (!judgeIsSupport(version)) {
            Bundle result = new Bundle();
            result.putInt(ParamKeywords.KEY_int_ret, ErrorCode.RET_NOT_SUPPORT);
            return result;
        }

        //判断是否支持此方法
        if (method.equals(ParamKeywords.KEY_METHOD_GetBinder)) {
            Bundle result = new Bundle();
            result.putInt(ParamKeywords.KEY_int_ret, 0);
            result.putBinder(ParamKeywords.KEY_Binder_Binder, UniteAuthBinder.getInstance(getContext()));
            return result;
        } else {
            Bundle result = new Bundle();
            result.putInt(ParamKeywords.KEY_int_ret, ErrorCode.RET_NO_SUCH_METHOD);
            return result;
        }
    }

    /**
     * 判断是否支持此版本
     *
     * @param version
     * @return
     */
    private boolean judgeIsSupport(int version) {
        //当前只支持版本1
        if (version == 1) {
            return true;
        }
        return false;
    }

}
