package com.xdja.uniteauth.bean;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by xdja-yogapro3 on 2016/1/14.
 */
public class ClientToken implements Parcelable {
//    {
//        “token_data”:
//        {
//            “teamIdentifier”:  “Team Identity，用16字节的16进展数据表示”,
//            “teamName”:  “开发者ID账号名” ,
//            “appId”:  “应用的标识，用16字节的16进展数据表示”,
//            “appName”:  “应用名称”,
//            “appIDPre”:  “完整App ID的前缀（TeamIdentifier.*）”,
//            “cer”:  “用户证书”,
//            ” entitlement “：”应用间访问授权字段“//该字段暂不使用
//            "suit": 2561    //加密套件编号
//        },
//        “signature_alg” : ”rsa”, //签名算法类型
//        “signature”: “AeFFz0NqHF5KXh6A==”//Base64编码的签名数据—开发者平台签名
//    }

    private String signature_alg;
    private String signature;
    private TokenData token_data;

    public String getSignature_alg() {
        return signature_alg;
    }

    public void setSignature_alg(String signature_alg) {
        this.signature_alg = signature_alg;
    }

    public String getSignature() {
        return signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public TokenData getToken_data() {
        return token_data;
    }

    public void setToken_data(TokenData token_data) {
        this.token_data = token_data;
    }

    @Override
    public String toString() {
        return "ClientToken{" +
                "signature_alg='" + signature_alg + '\'' +
                ", signature='" + signature + '\'' +
                ", token_data=" + token_data +
                '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.signature_alg);
        dest.writeString(this.signature);
        dest.writeParcelable(this.token_data, flags);
    }

    public ClientToken() {
    }

    protected ClientToken(Parcel in) {
        this.signature_alg = in.readString();
        this.signature = in.readString();
        this.token_data = in.readParcelable(TokenData.class.getClassLoader());
    }

    public static final Creator<ClientToken> CREATOR = new Creator<ClientToken>() {
        @Override
        public ClientToken createFromParcel(Parcel source) {
            return new ClientToken(source);
        }

        @Override
        public ClientToken[] newArray(int size) {
            return new ClientToken[size];
        }
    };
}
