package com.xdja.uniteauth.bean;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by xdja-yogapro3 on 2016/1/14.
 */
public class TokenData implements Parcelable {
    //            “teamIdentifier”:  “Team Identity，用16字节的16进展数据表示”,
//            “teamName”:  “开发者ID账号名” ,
//            “appId”:  “应用的标识，用16字节的16进展数据表示”,
//            “appName”:  “应用名称”,
//            “appIDPre”:  “完整App ID的前缀（TeamIdentifier.*）”,
//            “cer”:  “用户证书”,
//            ” entitlement “：”应用间访问授权字段“//该字段暂不使用
//            "suit": 2561    //加密套件编号

    private String teamIdentifier;
    private String teamName;
    private String appId;
    private String packageName;
    private String appIDPre;
    private String cer;
    private String entitlement;
    private int suit;

    public int getSuit() {
        return suit;
    }

    public void setSuit(int suit) {
        this.suit = suit;
    }

    public String getTeamIdentifier() {
        return teamIdentifier;
    }

    public void setTeamIdentifier(String teamIdentifier) {
        this.teamIdentifier = teamIdentifier;
    }

    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public String getAppID(){
        return appId;
    }

    public void setAppID(String appID) {
        this.appId = appID;
    }
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }
    public String getPackageName() {
        return packageName;
    }

    public void setAppName(String appName) {
        this.packageName = appName;
    }

    public String getAppIDPre() {
        return appIDPre;
    }

    public void setAppIDPre(String appIDPre) {
        this.appIDPre = appIDPre;
    }

    public String getCer() {
        return cer;
    }

    public void setCer(String cer) {
        this.cer = cer;
    }

    public String getEntitlement() {
        return entitlement;
    }

    public void setEntitlement(String entitlement) {
        this.entitlement = entitlement;
    }

    @Override
    public String toString() {
        return "TokenData{" +
                "teamIdentifier='" + teamIdentifier + '\'' +
                ", teamName='" + teamName + '\'' +
                ", appID='" + appId + '\'' +
                ", packageName='" + packageName + '\'' +
                ", appIDPre='" + appIDPre + '\'' +
                ", cer='" + cer + '\'' +
                ", entitlement='" + entitlement + '\'' +
                ", suit=" + suit + '\''+
                '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.teamIdentifier);
        dest.writeString(this.teamName);
        dest.writeString(this.appId);
        dest.writeString(this.packageName);
        dest.writeString(this.appIDPre);
        dest.writeString(this.cer);
        dest.writeString(this.entitlement);
    }

    public TokenData() {
    }

    protected TokenData(Parcel in) {
        this.teamIdentifier = in.readString();
        this.teamName = in.readString();
        this.appId = in.readString();
        this.packageName = in.readString();
        this.appIDPre = in.readString();
        this.cer = in.readString();
        this.entitlement = in.readString();
    }

    public static final Creator<TokenData> CREATOR = new Creator<TokenData>() {
        @Override
        public TokenData createFromParcel(Parcel source) {
            return new TokenData(source);
        }

        @Override
        public TokenData[] newArray(int size) {
            return new TokenData[size];
        }
    };
}
