package com.xdja.uniteauth.cache;

import android.text.TextUtils;

import com.xdja.uniteauth.ApplicationContext;
import com.xdja.uniteauth.persistent.PropertyUtilUAC;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by wzg on 2018/7/31
 */
public class ConfigCacheUAC {

   public final String[] KEYS = {DataConstDefUAC.KEY_APP_ENDPOINT_UAC,
           DataConstDefUAC.IS_FULL_LOG};

    private Map<String,String> configEntity;

    private PropertyUtilUAC propertyUtil2;


    private ConfigCacheUAC(){}

    public static ConfigCacheUAC getInstance(){
        return ConfigCacheInstanceHolder.configCacheUAC;
    }

    private static class ConfigCacheInstanceHolder{
        private static final ConfigCacheUAC configCacheUAC =
                new ConfigCacheUAC(new PropertyUtilUAC(ApplicationContext.getContext()));
    }


    private ConfigCacheUAC(PropertyUtilUAC propertyUtil2){
        this.propertyUtil2 = propertyUtil2;
    }

    public Map<String, String> get() {

        if (configEntity==null){
            try {
                propertyUtil2.load(DataConstDefUAC.PRONAME);
                this.configEntity = new HashMap<>();

                if (KEYS != null){
                    for (String key : KEYS){

                        if (!TextUtils.isEmpty(key)){
                            String value = propertyUtil2.get(key);
                            this.configEntity.put(key,value);
                        }

                    }
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return configEntity;
    }
}
