package com.xdja.uniteauth.data;

import android.content.Context;


import com.xdja.uniteauth.cache.ConfigCacheUAC;
import com.xdja.uniteauth.cache.DataConstDefUAC;
import com.xdja.uniteauth.data.net.UnitAuthApi;
import com.xdja.uniteauth.net.RetrofitBuilder;
import com.xdja.uniteauth.net.RetrofitOkClient;

import java.util.HashMap;
import java.util.Map;

import retrofit.RequestInterceptor;
import retrofit.RestAdapter;


/**
 * date:   2017/10/17 15:12 <br/>
 */

public class ApiGen {
//    public static String BASE_URL = BuildConfig.API_BASE_URL;

    private static final String HEAD_CONTENT_TYPE = "Content-Type";

    private Context context;
    private static ApiGen apiGen;

    /*public static ApiGen getInstance(Context context) {

        if (apiGen == null) {
            synchronized (ApiGen.class) {
                if (apiGen == null) {
                    apiGen = new ApiGen(context);
                }
            }
        }

        return apiGen;
    }*/

    private ApiGen(Context context) {
        this.context = context.getApplicationContext();
    }


    public static UnitAuthApi genUnitAuthApi(){
        return generateApi(UnitAuthApi.class);
    }

    public static <T> T generateApi(Class<T> service) {

        ConfigCacheUAC configCacheUAC = ConfigCacheUAC.getInstance();
        String endPoint = configCacheUAC.get().get(DataConstDefUAC.KEY_APP_ENDPOINT_UAC);

        return RetrofitBuilder.INSTANCE.getRetrofitBuilder()
                .setClient(RetrofitOkClient.INSTANCE.getOkClient())
                .setEndpoint(endPoint)
                .setRequestInterceptor(new RequestInterceptor() {
                    @Override
                    public void intercept(RequestFacade request) {


/*                        request.addHeader(CARD_ID, cardId);
                        request.addHeader(SN,sn);*/
                        request.addHeader(HEAD_CONTENT_TYPE, "application/json; charset=UTF-8");

                    }
                })
                .setLogLevel(getRestLogLevel())
                .build()
                .create(service);
    }


    //设置loglevel 级别
    private static RestAdapter.LogLevel getRestLogLevel(){
        RestAdapter.LogLevel logLevel = RestAdapter.LogLevel.BASIC;

        ConfigCacheUAC configCacheUAC = ConfigCacheUAC.getInstance();
        Map<String, String> configMap = configCacheUAC.get();
        if(configMap != null){

            //如果明确配置为不打印全日志
            if(DataConstDefUAC.FLASE_FLAG.equals(configMap.get(DataConstDefUAC.IS_FULL_LOG))){
                logLevel = RestAdapter.LogLevel.NONE;
            }else {
                logLevel = RestAdapter.LogLevel.FULL;
            }
        }

        return logLevel;
    }
}
