package com.xdja.uniteauth.data.net;

import com.xdja.uniteauth.data.net.model.CheckPkgRequest;
import com.xdja.uniteauth.data.net.model.GetAuthCodeRequest;
import com.xdja.uniteauth.data.net.model.UASResponseBean;

import retrofit.Callback;
import retrofit.http.Body;
import retrofit.http.GET;
import retrofit.http.Header;
import retrofit.http.Headers;
import retrofit.http.POST;

/**
 * <br>author: wzg@xdja.com <br/>
 * date:   2018/7/31 16:45 <br/>
 */
public interface UnitAuthApi {

    @GET("/api/v1/authorize/challenge")
    void  getChallenge(Callback<UASResponseBean> cb);

    /**
     * 验证包公钥指纹
     * @param appId 应用标识
     * @param cb 结果回调
     */
    @POST("/api/v1/authorize/package")
    void  checkPkgSign(@Header("appId") String appId,
                       @Body CheckPkgRequest checkPkgRequest,
                       Callback<UASResponseBean> cb);


    @POST("/api/v1/authorize/code")
    void  getAuthCode(@Header("appId") String appId,
                       @Header("chipId") String chipId,
                       @Header("sn") String sn,
                       @Body GetAuthCodeRequest getAuthCodeRequest,
                       Callback<UASResponseBean> cb);

}
