package com.xdja.uniteauth.domain;

import android.content.Context;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseIntArray;

import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.uniteauth.R;
import com.xdja.uniteauth.utils.PreferencesUtil_UAC;

/**
 * <br>author: wzg@xdja.com <br/>
 * date:   2018/8/2 9:20 <br/>
 */
public class AuthLoginManager {
    //是否需要输入PIN码：
    public static final String KEY_NEED_INPUT_PIN = "need_input_pin";


    public static SparseArray<String> serverErrCodeMap = new SparseArray<>();

    public static SparseIntArray cardTypeStrMap = new SparseIntArray(4);
    static {
        serverErrCodeMap.append(0X4001,"缺人必要请求参数");
        serverErrCodeMap.append(0X4002,"非法请求参数");
        serverErrCodeMap.append(0X4003,"请求方法不支持");
        serverErrCodeMap.append(0X4004,"服务内部异常");

        serverErrCodeMap.append(0x4201,"应用未注册");
        serverErrCodeMap.append(0X4202,"应用包名不匹配");
        serverErrCodeMap.append(0X4203,"包公钥签名不匹配");
        serverErrCodeMap.append(0X4204,"挑战值无效");
        serverErrCodeMap.append(0X4205,"证书未录入资产库");
        serverErrCodeMap.append(0X4206,"验签失败");
        serverErrCodeMap.append(0X4207,"未知授权模式");
        serverErrCodeMap.append(0X4208,"授权码无效");

        serverErrCodeMap.append(0X4209,"应用密钥不一致");
        serverErrCodeMap.append(0X420a,"无效的刷新凭证");
        serverErrCodeMap.append(0X420b,"证书状态异常");


        cardTypeStrMap.put(JniApiParam.TYPE_ONBOARD, R.string.uac_chip_name);
        cardTypeStrMap.put(JniApiParam.TYPE_TF, R.string.uac_tf_name);
        cardTypeStrMap.put(JniApiParam.TYPE_COVERED, R.string.uac_cover_card_name);
        cardTypeStrMap.put(JniApiParam.TYPE_BLUETOOTH, R.string.uac_blue_key_name);
    }


    public static boolean getIsNeedInputPin(Context context){
        return PreferencesUtil_UAC.getInstance(context).
                gPrefBooleanValue(KEY_NEED_INPUT_PIN, true);
    }

    public static void setNoNeedInputPin(Context context){
        PreferencesUtil_UAC.getInstance(context).
                setPreferenceBooleanValue(KEY_NEED_INPUT_PIN,false);
    }

    public static void setNeedInputPin(Context context){
        PreferencesUtil_UAC.getInstance(context).
                setPreferenceBooleanValue(KEY_NEED_INPUT_PIN,true);
    }

    public static int SM2SignByDefault(JarJniApiProxy jarJniApiProxy, String pin, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen){
        byte[] pubfid = new byte[2];
        byte[] prifid = new byte[2];

        // 签名证书 5
        int certType = 5;
        //6号容器
        int containNo = 6;

//        int SIGN_NOHASH = 1;
        int dataType = 1;

        byte[] certId = convertToFid(containNo, certType);
        pubfid[0] = 0x00;
        pubfid[1] = (byte) (certId[1] + 1);

        prifid[0] = 0x00;
        prifid[1] = (byte) (certId[1] + 2);

        int ret = jarJniApiProxy.SM2Sign(pubfid, prifid, dataType, dataIn, inLen, dataOut, outLen);
        Log.w("Auth", "SM2SignByDefault ret: " + ret);

        return ret;

    }

    /**
     * 将 容器号 和 类型 转换成 fid
     * @param containNo
     * 					容器号
     * @param certType
     * 					类型(容器名称、交换证书、交换公钥、交换私钥、签名证书、签名公钥、签名私钥)
     * @return
     */
    public static byte[] convertToFid(int containNo, int certType) {
        byte[] certId = new byte[2];

        certId[0] = 0x00;
        certId[1] = (byte) (0x27 + certType + containNo * 7);

        return certId;
    }


}
