package com.xdja.uniteauth.net;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import retrofit.RestAdapter;
import retrofit.converter.GsonConverter;

/**
 * <br>author: wzg@xdja.com <br/>
 * date:   2018/7/31 14:35 <br/>
 */
public enum RetrofitBuilder {

    INSTANCE;

    private final  RestAdapter.Builder retrofitBuilder;
    /**
     * 日志级别
     */
    private final RestAdapter.LogLevel logLevel = RestAdapter.LogLevel.FULL;

    RetrofitBuilder(){
        Gson gson = new GsonBuilder().serializeNulls().create();

        retrofitBuilder = new RestAdapter.Builder();

        retrofitBuilder
                .setLogLevel(logLevel)
                .setConverter(new GsonConverter(gson));
    }

    public RestAdapter.Builder getRetrofitBuilder(){
        return retrofitBuilder;
    }
}
