package com.xdja.uniteauth.utils;

import android.content.Context;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * 主要用于对Assets操作的类
 * author: zhangxiaolong@xdja.com
 * date:   2016/1/20
 */
public class AssetsUtil {

    /**
     * 将 assets中文件copy到指定path
     *
     * @param context
     * @param assetsFileName 在assets下的全路径,比如：pref.xml
     * @param path           要copy到的全路径，比如：/data/data/com.abc.def/files/zxy.ini
     * @return 0:成功；其他：失败
     */
    public static int copyAssetsFileToPath(Context context, String assetsFileName, String path) {
        int ret = 0;
        int last = path.lastIndexOf("/");
        String objDir = path.substring(0, last);
        String objName = path.substring(last + 1);

        File file = new File(objDir);
        if (!file.exists()) {
            file.mkdirs();
        }

        InputStream inputStream = null;

        try {
            inputStream = context.getAssets().open(assetsFileName);
            file = new File(objDir, objName);
            OutputStream outputStream = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            int length = inputStream.read(buffer);
            while (length > 0) {
                outputStream.write(buffer, 0, length);
                length = inputStream.read(buffer);
            }
            outputStream.flush();
            inputStream.close();
            outputStream.close();
        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

    /**
     * 得到文件的内容
     *
     * @param context
     * @param assetsFileName 在assets下的全路径,比如：pref.xml
     * @return
     */
    public static byte[] getFileContent(Context context, String assetsFileName) {
        InputStream inputStream = null;

        try {
            inputStream = context.getAssets().open(assetsFileName);
            int len = inputStream.available();
            byte[] buffer = new byte[len];
            inputStream.read(buffer);
            inputStream.close();
            return buffer;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}
