package com.xdja.uniteauth.utils;

import android.content.Context;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * author: zhangxiaolong@xdja.com
 * date:   2016/3/24
 */
public class GetValueFromProperties {

    /**
     * 得到assets下的properties文件中的值<br>
     *
     * @param context
     * @param filePath  在assets下的properties的路径.比如：assets目录下的 a/b.properties，则值为: "a/b.properties"
     * @param key
     * @return
     * @throws FileNotFoundException
     */
    public static String getValue(Context context, String filePath, String key) throws FileNotFoundException {

        if (context == null) {
            return "";
        }

        String result = "";
        Properties properties = null;
        try {
            InputStream is = context.getAssets().open(filePath);
            properties = new Properties();
            properties.load(is);
            is.close();
        } catch (IOException e) {
            e.printStackTrace();
            throw new FileNotFoundException();
        }

        if (properties != null) {
            result = properties.getProperty(key);
        }
        return result;
    }
}
