package com.xdja.uniteauth.utils;


import android.content.Context;
import android.text.TextUtils;
import android.util.Log;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;


public class ModuleConfigUtil_UAC {

    /**
     * 配置文件名称
     */
    public static final String PRO_NAME = "module.properties";
    /**
     * pin修改功能
     */
    public static final String KEY_PIN_CHANGE_MODULE = "pin_change_module";
    /**
     * pin解锁相关功能
     */
    public static final String KEY_PIN_UNLOCK_MODULE = "pin_unlock_module";
    /**
     * 备份恢复
     */
    public static final String KEY_BACKUP_RESTORE = "back_Restore";

    /*模块显示标签*/
    public static final String module_show_tag = "0";
    /*模块不显示标签*/
    public static final String module_not_show_tag = "1";


    private final String[] KEYS = {
            KEY_PIN_CHANGE_MODULE,
            KEY_PIN_UNLOCK_MODULE,
            KEY_BACKUP_RESTORE};

    private static Map<String,String> configEntity;

    private PropertyUtil_UAC propertyUtil;

    public ModuleConfigUtil_UAC(Context context) {
        this.propertyUtil = new PropertyUtil_UAC(context);
    }

    public Map<String,String> get() {
        if (configEntity == null) {
            try {

                this.propertyUtil.load(PRO_NAME);

                configEntity = new HashMap<>();
                if (KEYS != null) {
                    for (String key : KEYS){
                        if (TextUtils.isEmpty(key)) {
                            continue;
                        }
                        String value = this.propertyUtil.get(key);
                        configEntity.put(key,value);
                    }
                }
            }catch (IOException e){
                Log.w("ModuleConfig","current version not contain module config");
                configEntity = null;
            }
        }

        return configEntity;
    }

    private static boolean isShowModule(Context context, String moduleName){
        if(context  == null){
            return true;
        }

        //默认显示模块
        boolean isShow = true;

        ModuleConfigUtil_UAC configPropertyUtil = new ModuleConfigUtil_UAC(context.getApplicationContext());
        Map<String, String> configMap = configPropertyUtil.get();

        if(configMap != null){

            String showTag = configMap.get(moduleName);

            isShow = module_show_tag.equals(showTag);
        }

        return isShow;
    }

    public static boolean isShowPINUnlockModule(Context context){
        return isShowModule(context,KEY_PIN_UNLOCK_MODULE);
    }

    public static boolean isShowBackUpRestoreModule(Context context){
        return isShowModule(context,KEY_BACKUP_RESTORE);
    }

    public static boolean isShowPINChangeModule(Context context){
        return isShowModule(context,KEY_PIN_CHANGE_MODULE);
    }
}
