package com.xdja.uniteauth.utils;


import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.preference.PreferenceManager;

public class PreferencesUtil_UAC {

    private SharedPreferences sp;
    private Editor sharedEditor;

    private static PreferencesUtil_UAC preferencesUtil;

    public static PreferencesUtil_UAC getInstance(Context context){
        if (context == null) {
            return null;
        }

        if(preferencesUtil == null){
            synchronized (PreferencesUtil_UAC.class){
                if(preferencesUtil == null){
                    preferencesUtil = new PreferencesUtil_UAC(context.getApplicationContext());
                }
            }
        }

        return preferencesUtil;
    }


    private PreferencesUtil_UAC(Context aContext) {
        sp = PreferenceManager.getDefaultSharedPreferences(aContext);
        sharedEditor = sp.edit();
    }

    /**
     * Set a preference string value
     *
     * @param key   the preference key to set
     * @param value the value for this key
     */
    public boolean setPreferenceStringValue(String key, String value) {
        if (sharedEditor == null) {
            Editor editor = sp.edit();
            editor.putString(key, value);
            return editor.commit();
        } else {
            sharedEditor.putString(key, value);
            return sharedEditor.commit();
        }
    }

    /**
     * Set a preference boolean value
     *
     * @param key   the preference key to set
     * @param value the value for this key
     */
    public boolean setPreferenceBooleanValue(String key, boolean value) {
        if (sharedEditor == null) {
            Editor editor = sp.edit();
            editor.putBoolean(key, value);
            return editor.commit();
        } else {
            sharedEditor.putBoolean(key, value);
            return sharedEditor.commit();
        }
    }

    /**
     * Set a preference float value
     *
     * @param key   the preference key to set
     * @param value the value for this key
     */
    public boolean setPreferenceFloatValue(String key, float value) {
        if (sharedEditor == null) {
            Editor editor = sp.edit();
            editor.putFloat(key, value);
            return editor.commit();
        } else {
            sharedEditor.putFloat(key, value);
            return sharedEditor.commit();
        }
    }

    /**
     * Set a preference int value
     *
     * @param key   the preference key to set
     * @param value the value for this key
     */
    public boolean setPreferenceIntValue(String key, int value) {
        if (sharedEditor == null) {
            Editor editor = sp.edit();
            editor.putInt(key, value);
            return editor.commit();
        } else {
            sharedEditor.putInt(key, value);
            return sharedEditor.commit();
        }
    }

    /**
     * Set a preference long value
     *
     * @param key   the preference key to set
     * @param value the value for this key
     */
    public boolean setPreferenceLongValue(String key, long value) {
        if (sharedEditor == null) {
            Editor editor = sp.edit();
            editor.putLong(key, value);
            return editor.commit();
        } else {
            sharedEditor.putLong(key, value);
            return sharedEditor.commit();
        }
    }

    //Private static getters
    // For string
    public String gPrefStringValue(String key) {
        return sp.getString(key, "");
    }

    // For boolean
    public Boolean gPrefBooleanValue(String key, boolean defaultValue) {
        return sp.getBoolean(key, defaultValue);
    }

    // For int
    public int gPrefIntValue(String key) {
        return sp.getInt(key, 0);
    }

    // For long
    public long gPrefLongValue(String key) {
        return sp.getLong(key,-1);
    }

    // For float
    public float gPrefFloatValue(String key) {
        return sp.getFloat(key, 0);
    }

    public void clearAllData(){

    }
}
