package com.xdja.uniteauth.utils;

import android.content.Context;
import android.text.TextUtils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * <p>Summary:配置文件操作类</p>
 * <p>Description:</p>
 * <p>Package:com.xdja.imp.data.persistent</p>
 * <p>Author:fanjiandong</p>
 * <p>Date:2015/12/16</p>
 * <p>Time:13:39</p>
 */
public class PropertyUtil_UAC {
    /**
     * 上下文句柄
     */
    private Context context;
    /**
     * 配置文件对象
     */
    private Properties properties;

    public PropertyUtil_UAC(
                        Context context) {
        this.context = context;
    }

    /**
     * 从某个文件中加载配置
     *
     * @param fileName 文件名称
     */
    public void load(String fileName) throws IOException {

        if (TextUtils.isEmpty(fileName)) {
            return;
        }

        InputStream is = this.context.getAssets().open(fileName);
        properties = new Properties();
        properties.load(is);
    }

    /**
     * 获取一个配置的值
     *
     * @param name key
     * @return value
     */
    public String get(String name) {
        if (properties != null && !TextUtils.isEmpty(name)) {
            return properties.getProperty(name);
        }
        return null;
    }

    /**
     * 获取一个配置的值
     *
     * @param name         key
     * @param defaultValue 默认值
     * @return value
     */
    public String get(String name, String defaultValue) {
        if (properties != null && !TextUtils.isEmpty(name)) {
            return properties.getProperty(name, defaultValue);
        }
        return null;
    }
}
