package com.xdja.ckms.common;

import android.app.Activity;


import com.xdja.ckms.common.util.LogUtil;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @author fanjiandong
 * @summary Activity堆栈管理类
 * @description
 * @time 2014-12-1 下午4:06:17
 */
public class ActivityController {

    private static ActivityController instance;

    public static ActivityController getInstance() {
        if (instance == null)
            instance = new ActivityController();
        return instance;
    }

    /**
     * 释放单例对象
     */
    public static void release() {
        if (instance.getActivityList() != null) {
            instance.dispose();
        }
        instance = null;
    }

    private List<BasePresenterActivity> activityList;

    private List<BasePresenterActivity> pinFlowPinList;

    private List<BasePresenterActivity> changePhoneList;

    private List<BasePresenterActivity> jihuoList;

    private List<BasePresenterActivity> backUpList;

    private List<BasePresenterActivity> recoveryList;

    private List<BasePresenterActivity> unlockUsbKey;

    private List<BasePresenterActivity> newRecoveryList;

    //private Map<String,BasePresenterActivity> mapActivities;

    public List<BasePresenterActivity> getActivityList() {
//		if (this.activityList == null)
//			this.activityList = new ArrayList<BasePresenterActivity>();
        return activityList;
    }

    private ActivityController() {

    }

    /**
     * 向Activity管理堆栈中存放Activity
     *
     * @param activity 目标Activity
     */
    public void addActivity(BasePresenterActivity activity) {
        if (this.activityList == null)
            this.activityList = new ArrayList<BasePresenterActivity>();
        activityList.add(activity);
    }

    public void addPinActivity(BasePresenterActivity activity) {
        //addActivity(activity);
        if (this.pinFlowPinList == null)
            this.pinFlowPinList = new ArrayList<BasePresenterActivity>();
        pinFlowPinList.add(activity);
    }

    public void addChangePhoneNumActivity(BasePresenterActivity activity) {
        //addActivity(activity);
        if (this.changePhoneList == null)
            this.changePhoneList = new ArrayList<BasePresenterActivity>();
        changePhoneList.add(activity);
    }

    public void addJihuoListActivity(BasePresenterActivity activity) {
        //addActivity(activity);
        if (this.jihuoList == null)
            this.jihuoList = new ArrayList<BasePresenterActivity>();
        jihuoList.add(activity);
    }

    public void addBackUpListActivity(BasePresenterActivity activity) {
        //addActivity(activity);
        if (this.backUpList == null)
            this.backUpList = new ArrayList<BasePresenterActivity>();
        backUpList.add(activity);
    }
    public void addRecoveryListActivity(BasePresenterActivity activity) {
        //addActivity(activity);
        if (this.recoveryList == null)
            this.recoveryList = new ArrayList<BasePresenterActivity>();
        recoveryList.add(activity);
    }
    public void addPrivateRegionsRecoveryListActivity(BasePresenterActivity activity) {
        //addActivity(activity);
        if (this.newRecoveryList == null)
            this.newRecoveryList = new ArrayList<BasePresenterActivity>();
        newRecoveryList.add(activity);
    }
    public void addUnlockUsbKeyListActivity(BasePresenterActivity activity) {
        //addActivity(activity);
        if (this.unlockUsbKey == null)
            this.unlockUsbKey = new ArrayList<BasePresenterActivity>();
        unlockUsbKey.add(activity);
    }


    /**
     * 将Activity从堆栈中移除
     *
     * @param activity 目标Acitivity
     */
    public void removeActivity(BasePresenterActivity activity) {
        if (activityList != null) {
            if (activityList.contains(activity)) {
                activityList.remove(activity);
            }
        }
        if (pinFlowPinList != null) {
            if (pinFlowPinList.contains(activity)) {
                pinFlowPinList.remove(activity);
            }
        }
        if (changePhoneList != null) {
            if (changePhoneList.contains(activity)) {
                changePhoneList.remove(activity);
            }
        }
        if (jihuoList != null) {
            if (jihuoList.contains(activity)) {
                jihuoList.remove(activity);
            }
        }
        if (backUpList != null) {
            if (backUpList.contains(activity)) {
                backUpList.remove(activity);
            }
        }
        if (unlockUsbKey != null){
            if (unlockUsbKey.contains(activity)){
                unlockUsbKey.remove(activity);
            }
        }

    }

    /**
     * 完全退出
     */
    public void exit() {
        if (activityList != null && !activityList.isEmpty()) {
            try {
                for (BasePresenterActivity ac : activityList) {
                    ac.finish();
                }
            } catch (Exception e) {
                LogUtil.getUtils().e(e.getMessage());
            }
        }
        if (pinFlowPinList != null && !pinFlowPinList.isEmpty()) {
            try {
                for (BasePresenterActivity ac : pinFlowPinList) {
                    ac.finish();
                }
            } catch (Exception e) {
                LogUtil.getUtils().e(e.getMessage());
            }
        }
        if (recoveryList != null && !recoveryList.isEmpty()) {
            try {
                for (BasePresenterActivity ac : recoveryList) {
                    ac.finish();
                }
            } catch (Exception e) {
                LogUtil.getUtils().e(e.getMessage());
            }
        }
        if (newRecoveryList != null && !newRecoveryList.isEmpty()) {
            try {
                for (BasePresenterActivity ac : newRecoveryList) {
                    ac.finish();
                }
            } catch (Exception e) {
                LogUtil.getUtils().e(e.getMessage());
            }
        }
        if (backUpList != null && !backUpList.isEmpty()) {
            try {
                for (BasePresenterActivity ac : backUpList) {
                    ac.finish();
                }
            } catch (Exception e) {
                LogUtil.getUtils().e(e.getMessage());
            }
        }

    }

    public void dispose() {
        activityList = null;
    }

    /**
     * 根据class name获取activity
     * <p/>
     * Acitivity名称
     *
     * @return 获得的对象
     */
    public Activity getActivityByClassName(String activityName) {
        if (activityList == null || activityList.isEmpty()) {
            return null;
        }
        for (Activity ac : activityList) {
            if (ac.getClass().getName().indexOf(activityName) >= 0) {
                return ac;
            }
        }
        return null;
    }

    /**
     * 根据Activity类名获取Activity对象
     *
     * @param cs Activity的class对象
     * @return 获得的对象
     */
    public BasePresenterActivity getActivityByClass(Class<BasePresenterActivity> cs) {
        if (activityList == null || activityList.isEmpty()) {
            return null;
        }
        for (BasePresenterActivity ac : activityList) {
            if (ac.getClass().equals(cs)) {
                return ac;
            }
        }
        return null;
    }

    /**
     * 弹出activity
     *
     * @param activity
     */
    public void popActivity(BasePresenterActivity activity) {
        removeActivity(activity);
        activity.finish();
    }

    /**
     * 弹出activity到
     *
     * @param cs
     */
    public <T extends BasePresenterActivity> void popUntilActivity(Class<T>... cs) {
        if (activityList == null || activityList.isEmpty()) {
            return;
        }
        List<BasePresenterActivity> list = new ArrayList<BasePresenterActivity>();
        for (int i = activityList.size() - 1; i >= 0; i--) {
            BasePresenterActivity ac = activityList.get(i);
            boolean isTop = false;
            for (int j = 0; j < cs.length; j++) {
                if (ac.getClass().equals(cs[j])) {
                    isTop = true;
                    break;
                }
            }
            if (!isTop) {
                list.add(ac);
            } else
                break;
        }
        for (Iterator<BasePresenterActivity> iterator = list.iterator();
             iterator.hasNext(); ) {
            BasePresenterActivity activity = iterator.next();
            popActivity(activity);
        }
    }


    /**
     * 退出所有的activity
     */
    public void popAllActivity() {
        if (activityList == null || activityList.isEmpty()) {
            return;
        }
        try {
            for (BasePresenterActivity ac : activityList) {
                ac.finish();
            }

            //add 2017年7月20日20:30:17 weizg 新增清空列表，减少界面引用
            activityList.clear();
            LogUtil.getUtils().d("activityList size: " + activityList.size());
        } catch (Exception e) {
            LogUtil.getUtils().e(e.getMessage());
        }
    }

    public void popAllExc(Activity activity) {
        if (activityList == null || activityList.isEmpty()) {
            return;
        }
        try {
            for (int i = activityList.size() - 1; i >= 0; i--) {
                BasePresenterActivity basePresenterActivity = activityList.get(i);
                if (basePresenterActivity.getClass().getSimpleName()
                        .equals(activity.getClass().getSimpleName())) {
                    LogUtil.getUtils().d("===========popAllExc:"+activity.getClass().getSimpleName()+"==============");
                    continue;
                }
                basePresenterActivity.finish();
            }
        } catch (Exception e) {
            LogUtil.getUtils().e(e.getMessage());
        }
    }

    /**
     * 发出好友请求成功之后关闭搜索之前
     */
    public void finishPinFlowActivity() {
        int length = pinFlowPinList.size();
        if (length==0)
            return;
        for (int index = length - 1; index >= 0; index--) {
            pinFlowPinList.get(index).finish();
        }
        pinFlowPinList.clear();
    }
    /**
     * 发出好友请求成功之后关闭搜索之前
     */
    public void finishChangePhoneNumActivity() {
        int length = changePhoneList.size();
        for (int index = length - 1; index >= 0; index--) {
            changePhoneList.get(index).finish();
        }
        changePhoneList.clear();
    }
    /**
     * 发出好友请求成功之后关闭搜索之前
     */
    public void finishJihuoFlowActivity() {
        int length = jihuoList.size();
        for (int index = length - 1; index >= 0; index--) {
            jihuoList.get(index).finish();
        }
        jihuoList.clear();
    }

    /**
     * 结束备份流程所有界面
     */
    public void finishBackUpActivity() {
        int length = backUpList.size();
        for (int index = length - 1; index >= 0; index--) {
            backUpList.get(index).finish();
        }
        backUpList.clear();
    }

    /**
     * 结束恢复流程所有界面
     */
    public void finishRecoveryActivity(){
        int length = recoveryList.size();
        for(int index = length -1;index >=0 ;index--){
            recoveryList.get(index).finish();
        }
        recoveryList.clear();
    }
    /**
     * 结束私有化恢复流程所有界面
     */
    public void finishPrivateRegionsRecoveryActivity(){
        int length = newRecoveryList.size();
        for(int index = length -1;index >=0 ;index--){
            newRecoveryList.get(index).finish();
        }
        newRecoveryList.clear();
    }

    /**
     * 结束备份和恢复所有的activity
     */
    public void finishRecoveryAndBackUpActivity(){
        recoveryList.addAll(backUpList);
        int length = recoveryList.size();
        for(int index = length -1;index >=0;index--){
            recoveryList.get(index).finish();
        }
        recoveryList.clear();
    }
    /**
     * 结束扫一扫解锁usbkey流程所有界面
     */
    public void finishUnlockUsbKeyActivity(){
        int length = unlockUsbKey.size();
        for(int index = length -1;index >=0 ;index--){
            unlockUsbKey.get(index).finish();
        }
        unlockUsbKey.clear();
    }

}
