package com.xdja.ckms.common.chip;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/8/7 <br/>
 */

public class AppChipParam implements Parcelable {
    /**
     * 芯片
     */
    public static final int TYPE_ONBOARD = 1;
    /**
     * TF卡类型
     */
    public static final int TYPE_TF = 2;

    /**
     * 蓝牙Key
     */
    public static final int TYPE_BLUETOOTH = 4;

    /**
     * 贴膜卡
     */
    public static final int TYPE_COVER = 8;

    /**
     * 芯片所属厂商 -- 信大捷安
     */
    public static final String MANUFACTURER_XDJA = "xdja";

    /**
     * 类型
     */
    public int chipType;
    /**
     * 芯片的唯一标识
     */
    public String uniqueID;

    /**
     * 哪个公司的芯片
     */
    public String manufacturer;

    public AppChipParam() {

    }

    protected AppChipParam(Parcel in) {
        chipType = in.readInt();
        uniqueID = in.readString();
        manufacturer = in.readString();
    }

    public static final Creator<AppChipParam> CREATOR = new Creator<AppChipParam>() {
        @Override
        public AppChipParam createFromParcel(Parcel in) {
            return new AppChipParam(in);
        }

        @Override
        public AppChipParam[] newArray(int size) {
            return new AppChipParam[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(chipType);
        dest.writeString(uniqueID);
        dest.writeString(manufacturer);
    }
}
