package com.xdja.ckms.common.chip;

import android.content.Context;
import android.os.Bundle;
import android.util.Pair;

import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.multichip.jniapi.JarMultiJniApiManager;
import com.xdja.multichip.param.JniApiParam;

import java.util.Arrays;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/8/7 <br/>
 */

class UseMultiJniApi {

    static int ChangePin(Context context, JniApiParam jniApiParam, String oldPin, String newPin, int role) {
        Pair<Integer, JarJniApiProxy> proxyPair = JarMultiJniApiManager.getInstance().make(context, jniApiParam.cardId);
        if (proxyPair.first != 0) {
            return proxyPair.first;
        }
        return proxyPair.second.ChangePIN(role, oldPin.getBytes(), oldPin.length(), newPin.getBytes(), newPin.length());
    }

    static int VerifyPin(Context context, JniApiParam jniApiParam, String pin, int role) {
        Pair<Integer, JarJniApiProxy> proxyPair = JarMultiJniApiManager.getInstance().make(context, jniApiParam.cardId);
        if (proxyPair.first != 0) {
            return proxyPair.first;
        }
        return proxyPair.second.VerifyPIN(role, pin.getBytes(), pin.length());
    }


    static int GetPinTryCount(Context context, JniApiParam jniApiParam, int role) {
        Pair<Integer, JarJniApiProxy> proxyPair = JarMultiJniApiManager.getInstance().make(context, jniApiParam.cardId);
        if (proxyPair.first != 0) {
            return proxyPair.first;
        }
        return proxyPair.second.GetPinTryCount(role);
    }


    /**
     * 特指6号容器的签名证书
     * @param context
     * @param jniApiParam
     * @return
     */
    static Pair<Integer, byte[]> GetCert(Context context, JniApiParam jniApiParam) {
        Pair<Integer, JarJniApiProxy> proxyPair = JarMultiJniApiManager.getInstance().make(context, jniApiParam.cardId);
        if (proxyPair.first != 0) {
            return Pair.create(proxyPair.first,null);
        }
        byte[] fid = {0x00,0x56};
        byte[] certBuf = new byte[2*1024];
        int[] certLen = new int[1];
        int ret = proxyPair.second.ReadCert(fid,certBuf,certLen);
        if (ret != 0){
            return Pair.create(ret,null);
        }
        byte[] result = Arrays.copyOfRange(certBuf,0,certLen[0]);

        return Pair.create(0,result);
    }

    static String getCosInfo(Context context, JniApiParam jniApiParam){
        Pair<Integer, JarJniApiProxy> proxyPair = JarMultiJniApiManager.getInstance().make(context, jniApiParam.cardId);
        if (proxyPair.first != 0) {
            return "";
        }
        XDJA_DEVINFO devinfo = new XDJA_DEVINFO();
        int ret = proxyPair.second.GetDevInfo(devinfo);
        if (ret != 0){
            return "";
        }
        return new String(devinfo.cosver);
    }

    static int UnlockPin(Context context, JniApiParam jniApiParam, int role, byte[] usn, byte[] usnlockCode) {
        Pair<Integer, JarJniApiProxy> proxyPair = JarMultiJniApiManager.getInstance().make(context, jniApiParam.cardId);
        if (proxyPair.first != 0) {
            return proxyPair.first;
        }
        byte[] newPin = new byte[6];
        //填充6个1
        Arrays.fill(newPin, (byte) 49);
        Bundle bundle = new Bundle();
        bundle.putString("method","UnlockPinUseUsn");
        bundle.putInt("role",role);
        bundle.putByteArray("usn",usn);
        bundle.putByteArray("usnlockCode",usnlockCode);
        bundle.putByteArray("newPin",newPin );
        Bundle result = proxyPair.second.callMethod(bundle);
        if (result == null){
            return -1;
        }
        return result.getInt("ret");
    }
}
