package com.xdja.ckms.common.chip;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import android.support.annotation.NonNull;
import android.text.TextUtils;

import org.json.JSONObject;

/**
 * Created by yangpeng on 2017/11/22.
 */

public class VerifyPinManager {

    private final int OK = 0;

    /**
     * 参数为空
     */
    private final int ERROR_PARAM_NULL = -1;

    private static VerifyPinManager manager;

    public static VerifyPinManager getInstance() {
        if (manager == null) {
            synchronized (VerifyPinManager.class) {
                if (manager == null) {
                    manager = new VerifyPinManager();
                }
            }
        }
        return manager;
    }


    /**
     * 启动PIN码验证界面
     * @param context context
     * @param chipParam 芯片信息
     * @param mMessenger PIN码验证界面消息回调
     * @return 0 启动PIN码验证界面成功
     */
    public int startVerifyPin(@NonNull Context context, AppChipParam chipParam, @NonNull final Messenger mMessenger) {
        //modify 2017年8月11日10:47:40 weizg 因现在统一方式调用芯片接口，故chipParam不能为null
        if ((context == null) || (mMessenger == null) || chipParam == null
                || TextUtils.isEmpty(chipParam.uniqueID)){
            return ERROR_PARAM_NULL;
        }

        int role = 0x11;

        Bundle bundle = new Bundle();
        bundle.putBinder("bundle",mMessenger.getBinder());
        bundle.putInt("role", role);
        bundle.putParcelable(ChipOperate.param_AppParamChip,chipParam);
        Intent intent = new Intent();
        intent.setClassName("com.xdja.safekeyservice", "com.xdja.scservice.presenter.activity.VerifySafePinPresenter");
        intent.setPackage("com.xdja.safekeyservice");
        intent.putExtras(bundle);

        if (!(context instanceof Activity)) {
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        }
        context.startActivity(intent);

        return OK;
    }

    /**
     * 用于应用启动验证安全口令码界面 <br/><br/>
     *
     * <b>注意：</b>此方法有网络交互
     *
     * @param context 如果context是一个Activity，则从最近任务里面查看，启动的验证安全口令界面和接口调用者是同属一个进程；
     *                如果不是一个Activity，则验证安全口令界面和接口调用者应用分属两个进程
     * @param messenger PIN码验证界面消息回调
     * @return 成功：{"ret_code":0 } <br/>
    失败：{"ret_code":code, "err_msg":"error description"}
     */
    public int startVerifyPinActivity(@NonNull Context context, @NonNull Messenger messenger) {
        int role = 0x11;
        Bundle bundle = new Bundle();
        bundle.putBinder("bundle",messenger.getBinder());
        bundle.putInt("role", role);

        Intent intent = new Intent();
        intent.setClassName("com.xdja.safekeyservice", "com.xdja.scservice.presenter.activity.VerifySafePinPresenter");
        intent.setPackage("com.xdja.safekeyservice");
        intent.putExtras(bundle);
        if (!(context instanceof Activity)) {
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        }
        context.startActivity(intent);
        return OK;
    }

}
