package com.xdja.ckms.common.dilaog;

import android.app.Dialog;
import android.content.Context;
import android.support.annotation.StringRes;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import com.xdja.ckms.common.R;


/**
 *Created by yangpeng on 2016/12/08.
 */
public class BaseErrorDialog extends Dialog {

    public BaseErrorDialog(Context context) {
        super(context, R.style.Dialog);
    }

    public static class BaseErrorBuilder{
        private TextView tv_title;

        private TextView tv_content;

        private Button btn_positive;

        private Context context;

        private String title;
        private String content;
        private String btnText;
        private View.OnClickListener onClickListener;
        private BaseErrorDialog baseErrorDialog;

        public BaseErrorBuilder(Context context){
            this.context = context;
        }

        public BaseErrorBuilder setTitle(String title){
            this.title = title;
            return this;
        }
        public BaseErrorBuilder setTitle(@StringRes int title){
            this.title = context.getString(title);
            return this;
        }

        public BaseErrorBuilder setContent(@StringRes int content){
            this.content = context.getString(content);
            return this;
        }

        public BaseErrorBuilder setContent(String content){
            this.content = content;
            return this;
        }

        public BaseErrorBuilder setPositiveButton(@StringRes int id, View.OnClickListener onClickListener){
            this.btnText = context.getString(id);
            this.onClickListener = onClickListener;
            return this;
        }

        public BaseErrorDialog create(){
            baseErrorDialog = new BaseErrorDialog(context);
            baseErrorDialog.setContentView(R.layout.dialog_error_pin);
            initView();
            return baseErrorDialog;
        }


        private void initView(){
            tv_title = (TextView)baseErrorDialog.findViewById(R.id.tv_title);
            tv_title.setTextColor(context.getResources().getColor(R.color.error_pin_color));
            tv_title.setText(title);

            tv_content = (TextView)baseErrorDialog.findViewById(R.id.tv_content);
            tv_content.setText(content);

            btn_positive = (Button)baseErrorDialog.findViewById(R.id.btn_positive);
            btn_positive.setText(btnText);
            btn_positive.setOnClickListener(onClickListener);
        }
    }






}
