package com.xdja.ckms.common.dilaog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.StringRes;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import com.xdja.ckms.common.R;

/**
 * Created by guoyaxin on 2016/8/11.
 */
public class BindIdentifyDialog extends Dialog {

    public BindIdentifyDialog(Context context, int themeResId) {
        super(context, themeResId);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public static class Builder{

        private Context context;

        private OnClickListener positiveButtonClickListener;
        private OnClickListener negativeButtonClickListener;
        private String message;
        private String title;
        private String positiveButtonText;
        private String negativeButtonText;



        public Builder(Context context){
            this.context=context;
        }

        public Builder setPositiveButton(String positiveButtonText,OnClickListener onClickListener){
            this.positiveButtonText=positiveButtonText;
            this.positiveButtonClickListener=onClickListener;
            return this;
        }

        public Builder setPositiveButton(@StringRes int positiveButtonText,OnClickListener onClickListener){
            this.positiveButtonText=context.getString(positiveButtonText);
            this.positiveButtonClickListener=onClickListener;
            return this;
        }

        public Builder setNegativeButton(String negativeButtonText,OnClickListener onClickListener){
            this.negativeButtonText=negativeButtonText;
            this.negativeButtonClickListener=onClickListener;
            return this;
        }

        public Builder setNegativeButton(@StringRes int negativeButtonText,OnClickListener onClickListener){
            this.negativeButtonText=context.getString(negativeButtonText);
            this.negativeButtonClickListener=onClickListener;
            return this;
        }

        public Builder setMessage(String message){
            this.message=message;
            return this;
        }

        public Builder setMessage(@StringRes int message){
            this.message=context.getString(message);
            return this;
        }

        public Builder setTitle(String title){
            this.title=title;
            return this;
        }

        public Builder setTitle(@StringRes int title){
            this.title = context.getString(title);
            return this;
        }

//        @BindView(R.id.tv_title)
        TextView tv_title;

//        @BindView(R.id.tv_content)
        TextView tv_content;

//        @BindView(R.id.btn_negative)
        Button btn_negative;

//        @BindView(R.id.btn_positive)
        Button btn_positive;

        public BindIdentifyDialog create(){
            final BindIdentifyDialog bindIdentifyDialog=new BindIdentifyDialog(context,R.style.Theme_AppCompat_Dialog);
            bindIdentifyDialog.setContentView(R.layout.dialog_bind_identify);
            tv_title = (TextView) bindIdentifyDialog.findViewById(R.id.tv_title);
            tv_content = (TextView)bindIdentifyDialog.findViewById(R.id.tv_content);
            btn_negative = (Button)bindIdentifyDialog.findViewById(R.id.btn_negative);
            btn_positive = (Button)bindIdentifyDialog.findViewById(R.id.btn_positive);

            tv_title.setText(title);
            tv_content.setText(message);
            btn_negative.setText(negativeButtonText);
            btn_positive.setText(positiveButtonText);

            if (positiveButtonClickListener!=null){
                btn_positive.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        positiveButtonClickListener.onClick(bindIdentifyDialog,DialogInterface.BUTTON_POSITIVE);
                    }
                });
            }

            if (negativeButtonClickListener!=null){
                btn_negative.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        negativeButtonClickListener.onClick(bindIdentifyDialog,DialogInterface.BUTTON_NEGATIVE);
                    }
                });
            }

            return bindIdentifyDialog;
        }

    }

}
