package com.xdja.ckms.common.dilaog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.view.Display;
import android.view.Gravity;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.xdja.ckms.common.R;

import java.io.BufferedInputStream;

/**
 * Created by yangpeng on 2017/12/1.
 */

public class ListDiaolog extends Dialog {


    public ListDiaolog(@NonNull Context context, int themeResId) {
        super(context, themeResId);
        Window window = getWindow();
        window.setGravity(Gravity.BOTTOM);
        window.setWindowAnimations(R.style.bottom_dialog_anim);
        setContentView(R.layout.identification_manager_bottom_layout);

//        WindowManager manager = ((Activity)context).getWindowManager();
//        Display display = manager.getDefaultDisplay();
//        WindowManager.LayoutParams lp = getWindow().getAttributes();
//        lp.width = display.getWidth();
//        getWindow().setAttributes(lp);
        setCanceledOnTouchOutside(false);
    }

    public static class Builder{
        Context context;
        TextView change;
        TextView unbind;
        TextView delete;
        RelativeLayout change_info_layout;
        RelativeLayout unbind_info_layout;
        RelativeLayout delete_info_layout;

        View.OnClickListener unbindInfoListener;
        View.OnClickListener changeInfoListener;

        String unbindInfo;
        String changeInfo;
        public Builder(Context context){
            this.context = context;
        }

        public Builder setUnBindInfo(String unbindInfo){
            this.unbindInfo = unbindInfo;
            return this;
        }

        public Builder setChangeInfo(String changeInfo){
            this.changeInfo = changeInfo;
            return this;
        }

        public Builder setUnBindListener(View.OnClickListener unbindInfoListener){
            this.unbindInfoListener = unbindInfoListener;
            return this;

        }

        public Builder setChangeInfoListener(View.OnClickListener changeInfoListener){
            this.changeInfoListener = changeInfoListener;
            return this;
        }


        public ListDiaolog create(){
            final ListDiaolog listDiaolog =  new ListDiaolog(context, R.style.Theme_AppCompat_Dialog);
            change_info_layout = (RelativeLayout) listDiaolog.findViewById(R.id.change_info_layout);
            unbind_info_layout = (RelativeLayout) listDiaolog.findViewById(R.id.unbind_info_layout);
            delete_info_layout = (RelativeLayout) listDiaolog.findViewById(R.id.delete_info_layout);
            change = (TextView)listDiaolog.findViewById(R.id.change_info);
            unbind = (TextView)listDiaolog.findViewById(R.id.unbind_info);
            delete = (TextView)listDiaolog.findViewById(R.id.delete_info);
            change.setText(changeInfo);
            unbind.setText(unbindInfo);
            delete.setText(R.string.text_cancel);
            delete_info_layout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    listDiaolog.dismiss();
                }
            });
            change_info_layout.setOnClickListener(changeInfoListener);
            unbind_info_layout.setOnClickListener(unbindInfoListener);
            return listDiaolog;
        }
    }


}
