package com.xdja.ckms.common.dilaog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.widget.TextView;

import com.xdja.ckms.common.R;
import com.xdja.ckms.common.util.WeakReferenceHandler;


/**
 * loading 对话框
 * Created by guoyaxin on 2016/9/2.
 */
public class LoadingDialog extends Dialog {
    public LoadingDialog(Context context) {
        super(context, R.style.Theme_AppCompat_Dialog);
    }

    private TextView tv_content;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.loading_dialog);
        tv_content= (TextView) findViewById(R.id.tv_content);
        setCanceledOnTouchOutside(false);
    }


    public void setContent(String content){
        if (TextUtils.isEmpty(content))
            return;
        tv_content.setText(content);

    }



    private long startTime=0;
    private long dur = 500;
    private long endTime = 0;



    public void showLoading(){
        if (isShowing())
            return;
        startTime = System.currentTimeMillis();
        show();
    }



    public void dismissLoading(){
        if (isShowing()){
            endTime=System.currentTimeMillis();
            long del = endTime-startTime;
            if (del>dur){
                myHandler.removeMessages(MSG_DISMISS);
                dismiss();
            }else {
                long delay = startTime + dur -endTime;
                myHandler.sendEmptyMessageDelayed(MSG_DISMISS,delay);
            }

        }


    }

    private MyHandler myHandler = new MyHandler(this);
    private static final int MSG_DISMISS = 0;

   static class MyHandler extends WeakReferenceHandler<LoadingDialog> {

       public MyHandler(LoadingDialog reference) {
           super(reference);
       }

       @Override
       protected void handleMessage(LoadingDialog reference, Message msg) {
           Log.d("loadingDialog","handleMessage");
           //modify 2017年8月28日14:59:29 weizg  关闭对话框前，做非空和现在显示判断
           if(reference != null && reference.isShowing()){

               //add 2018年3月26日19:24:15 weizg
               //monkey测试发现，该dialog dismiss时其所依赖的activity已经销毁，
               //然后执行dismiss方法时会出现IllegalArgumentException，not attached to window manager
               try{
                   reference.dismiss();
               }catch (Exception e){
                   e.printStackTrace();
               }
           }
       }
   }



}
