package com.xdja.ckms.common.dilaog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.StringRes;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import com.xdja.ckms.common.R;


/**
 * Created by guoyaxin on 2016/9/20.
 */
public class RememberPinDialog extends Dialog {

    public RememberPinDialog(Context context) {
        super(context);
    }

    public RememberPinDialog(Context context, int themeResId) {
        super(context, themeResId);
    }


    public static class Builder{
        private Context context;
        private String title;

        private String positiveButtonText;
        private OnClickListener positiveButtonClickListener;

        public Builder(Context context){
            this.context=context;
        }

        public Builder setTitle(String title){
            this.title=title;
            return this;
        }

        public Builder setTitle(@StringRes int title){
            this.title = context.getString(title);
            return this;
        }

        public Builder setPositiveButton(String positiveButtonText,OnClickListener onClickListener){
            this.positiveButtonText=positiveButtonText;
            this.positiveButtonClickListener=onClickListener;
            return this;
        }

        public Builder setPositiveButton(@StringRes int positiveButtonText,OnClickListener onClickListener){
            this.positiveButtonText=context.getString(positiveButtonText);
            this.positiveButtonClickListener=onClickListener;
            return this;
        }


        public RememberPinDialog create(){
            final RememberPinDialog dialog=new RememberPinDialog(context,R.style.Dialog);
                dialog.setContentView(R.layout.dialog_remember_pin);
            if (title != null){
                TextView tv_title = (TextView) dialog.findViewById(R.id.tv_title);
                tv_title.setText(title);
            }
            if (positiveButtonText!=null){
                Button btn_positive= (Button) dialog.findViewById(R.id.btn_positive);
                btn_positive.setText(positiveButtonText);
                btn_positive.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        positiveButtonClickListener.onClick(dialog,DialogInterface.BUTTON_POSITIVE);
                    }
                });
            }

            return dialog;
        }
    }

}
