package com.xdja.ckms.common.presenter.activity;



import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;

import com.xdja.ckms.common.ActivityController;
import com.xdja.ckms.common.ActivityVu;
import com.xdja.ckms.common.BasePresenterActivity;
import com.xdja.ckms.common.Command;

import com.xdja.ckms.common.chip.AppChipParam;
import com.xdja.ckms.common.chip.ChipOperate;
import com.xdja.ckms.common.presenter.command.SoftInputCommand;
import com.xdja.ckms.common.util.LogUtil;
import com.xdja.ckms.common.util.LanguageSpUtils;
import com.xdja.ckms.common.util.Utils;

/**
 * Created by guoyaxin on 2016/8/2.
 */
public abstract class ActivityPresenter<P extends Command, V extends ActivityVu> extends BasePresenterActivity<P,V> implements SoftInputCommand {
//    private LocalBroadcastManager localBroadcastManager;
//    private BroadcastReceiver broadcastReceiver;
//    protected boolean isTfOut;
//    protected HaveNoChipDialog haveNoChipDialog;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        LanguageSpUtils.changeLanguage(this);   //设置语言要放到  所有控件相关操作  之前
        super.onCreate(savedInstanceState);
//        localBroadcastManager = ((AndroidApplication) this.getApplicationContext()).getLocalManager();
//        registBraodcastReceiver();
    }

    /**
     * 注册广播
     */
    private void registBraodcastReceiver(){
//        IntentFilter intentFilter = new IntentFilter();
//        intentFilter.addAction(RegisterActionUtil.LOCAL_BROADCASTRECEIVER_TF_OUT_ACTION);
//        BroadcastReceiver broadcastReceiver = new BroadcastReceiver() {
//            @Override
//            public void onReceive(Context context, Intent intent) {
//                if(intent.getAction().equals(RegisterActionUtil.LOCAL_BROADCASTRECEIVER_TF_OUT_ACTION));
//                isTfOut = true;
//                initTfHandleDialog();
//            }
//        };
//        localBroadcastManager.registerReceiver(broadcastReceiver,intentFilter);
    }

    private void initTfHandleDialog(){

        //del 2017年11月10日11:35:26 weizg
        //移动到common后，删除该dialog
        /*HaveNoChipDialog haveNoChipDialog = new HaveNoChipDialog(this, RegisterActionUtil.TF_CARD_OUT);


        haveNoChipDialog.setCanceledOnTouchOutside(false);
        haveNoChipDialog.setCancelable(false);
        haveNoChipDialog.show();

        haveNoChipDialog.setOnKeyListener(new DialogInterface.OnKeyListener() {
            @Override
            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                if(keyCode == KeyEvent.KEYCODE_BACK){
                    return false;
                }
                return false;
            }
        });*/
    }




    @Override
    public void handlleKeyBack() {
        if (Utils.isKeyboardShown(this)) {
            Utils.hideInputWindowDelay(this);
        } else {
            //getVu().finish();
            ActivityController.getInstance().popActivity(this);
        }
    }



    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            handlleKeyBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
//        if(haveNoChipDialog != null){
//            haveNoChipDialog.dismiss();
//        }
//        localBroadcastManager.unregisterReceiver(broadcastReceiver);
    }

    public static final String OTHERS = "others"; //其他需要传递的Bundle的key值
    public static final String HANDLE_PHONE_TYPE = "handle_phone_type"; //当跳转到PhonenumManagerPresenter页面，传递操作类型
    public static final String IS_IDENTIFICATION_BINDING= "is_identification_binding"; //当跳转到PhonenumManagerPresenter页面，传递是否身份信息是否绑定
    public static final int BIND_PHONE = 1;//绑定手机号操作
    public static final int CHANGE_PHONE = 2;//更改手机号操作


    /**
     * 此方法目的是跳转页面时传递共同的参数chipParam（可能连续传好几个界面）
     * chipParam之外的其他需要传递的参数，自行封装到Bundle里传进来
     * @param chipParam
     * @param tClass
     */
    public void startActivityViaChipParam(AppChipParam chipParam, Class<?> tClass, Bundle bundle){
//        if(chipParam == null){
//            return;
//        }
        Intent intent = new Intent(this,tClass);
        Bundle b = new Bundle();
        b.putParcelable(ChipOperate.param_AppParamChip,chipParam);
        if (bundle!=null){
            b.putBundle(OTHERS,bundle);
        }
        intent.putExtras(b);
        startActivity(intent);
    }

    /**
     * 获取存储其他参数的Bundle
     * @return
     */
    public  Bundle getOtherBundle(){
        Bundle bundle = getIntent().getExtras();
        Bundle others = bundle.getBundle(OTHERS);
        return others;
    }

}
