package com.xdja.ckms.common.presenter.fragment;

import android.os.Bundle;

import com.xdja.ckms.common.BasePresenterFragment;
import com.xdja.ckms.common.presenter.command.AbnormalPromptCommand;
import com.xdja.ckms.common.presenter.command.NetErrorCommand;
import com.xdja.ckms.common.presenter.ui.AbnormalPromptVu;
import com.xdja.ckms.common.presenter.view.AbnormalPromptView;

/**
 * 无网 或者 有网但网络不通 页面
 * Created by xwy on 2016/9/3.
 */
public class AbnormalPromptFragment extends BasePresenterFragment<AbnormalPromptCommand, AbnormalPromptVu> implements AbnormalPromptCommand {

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        if (getActivity() instanceof NetErrorCommand){
            int strId = ((NetErrorCommand) getActivity()).getErrorMsg();
            getVu().showMsg(strId);
        }
    }

    @Override
    protected Class<? extends AbnormalPromptVu> getVuClass() {
        return AbnormalPromptView.class;
    }

    @Override
    protected AbnormalPromptCommand getCommand() {
        return this;
    }

    @Override
    public void retry() {
           if (getActivity() instanceof NetErrorCommand){
               ((NetErrorCommand) getActivity()).retry();
           }
    }

}
