package com.xdja.ckms.common.presenter.view;

import android.support.annotation.StringRes;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;

import com.xdja.ckms.common.FragmentSuperView;
import com.xdja.ckms.common.R;
import com.xdja.ckms.common.presenter.command.AbnormalPromptCommand;
import com.xdja.ckms.common.presenter.ui.AbnormalPromptVu;

/**
 * Created by xwy on 2016/9/3.
 */
public class AbnormalPromptView extends FragmentSuperView<AbnormalPromptCommand> implements AbnormalPromptVu {

    //butterknife 在lib moudle中使用没有完全通过，修改为使用findviewByid方式
//    @BindView(R2.id.retry)
    Button retry;

//    @BindView(R2.id.abnormal_prompt)
    TextView abnormal_prompt;

    @Override
    public void init(LayoutInflater inflater, ViewGroup container) {
//        super.init(inflater, container);
        view = inflater.inflate(R.layout.abnormal_prompt,container,false);
        initView(view);

        injectView();
    }


    private void initView(View view) {
        retry = (Button) view.findViewById(R.id.retry);
        abnormal_prompt = (TextView) view.findViewById(R.id.abnormal_prompt);
    }

    @Override
    public void onCreated() {
        super.onCreated();
        init();
    }



    private void init(){
        retry.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getCommand().retry();
            }
        });
    }


    @Override
    public void showMsg(@StringRes int resId) {
        abnormal_prompt.setText(resId);
    }
}
