package com.xdja.ckms.common.presenter.view;

import android.support.annotation.IntDef;
import android.support.annotation.StringRes;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.xdja.ckms.common.ActivitySuperView;
import com.xdja.ckms.common.Command;
import com.xdja.ckms.common.R;
import com.xdja.ckms.common.presenter.command.SoftInputCommand;

/**
 * Created by guoyaxin on 2016/8/2.
 */
public class ActivityView<T extends Command> extends ActivitySuperView<T> {

//    @BindView(R2.id.toolbar)
    protected Toolbar toolbar;

//    @BindView(R2.id.title_tv)
    protected
    TextView title_tv;

//    @BindView(R2.id.left_title_tv)
    protected TextView left_title_tv;

    @Override
    public void init(LayoutInflater inflater, ViewGroup container) {
        super.init(inflater, container);
        initView(view);
    }

    private void initView(View view) {
        toolbar = (Toolbar)view.findViewById(R.id.toolbar);
        title_tv = (TextView)view.findViewById(R.id.title_tv);
        left_title_tv = (TextView)view.findViewById(R.id.left_title_tv);
    }

    @Override
    public void onCreated() {
        super.onCreated();

        initToolbar();
    }

    protected void initToolbar(){
        switch (getToolbarType()){
            case ToolBarDef.NAVIGATE_BACK:
                toolbar.setNavigationIcon(R.drawable.icon_back);
                toolbar.setNavigationOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
//                        getActivity().finish();
                        if (getActivity() instanceof SoftInputCommand){
                            ((SoftInputCommand) getActivity()).handlleKeyBack();
                        }else {
                            getActivity().finish();
                        }
                    }
                });
                break;
            case ToolBarDef.NAVIGATE_DEFAULT:
                toolbar.setLogo(R.drawable.icon_logo);
                break;
            case ToolBarDef.NAVIGATE_OTHER:
                toolbar.setNavigationIcon(null);
        }
        toolbar.setBackgroundColor(getActivity().getResources().getColor(R.color.toobar_background_color));
        toolbar.setTitle("");
        title_tv.setText(getTitleRes());
    }



    //设置显示Title
    @StringRes
    protected int getTitleRes(){
        return R.string.title;
    }

    @ToolBarDef.NavigateType
    protected int getToolbarType(){
        return ToolBarDef.NAVIGATE_BACK;
    }

    public static class ToolBarDef{

        //导航栏显示为后退
        public static final int NAVIGATE_BACK = 0;

        //默认导航栏
        public static final int NAVIGATE_DEFAULT =1;

        public static final int NAVIGATE_OTHER = 2;

        @IntDef({NAVIGATE_BACK,NAVIGATE_DEFAULT,NAVIGATE_OTHER})
        public @interface NavigateType{}

    }




}
