package com.xdja.ckms.common.presenter.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.xdja.ckms.common.R;


/**
 * Created by xwy on 2016/8/10.
 */
public class SettingItemLinearlayout_New extends RelativeLayout {


    RelativeLayout mContainer;

    public SettingItemLinearlayout_New(Context context) {
        super(context);
        initView(context);
    }

    public SettingItemLinearlayout_New(Context context, AttributeSet attrs) {
        super(context, attrs);

        initView(context);

        TypedArray typedArray = context.obtainStyledAttributes(attrs,
                R.styleable.SettingItemLinearlayout_New);

        CharSequence text_left = typedArray.getText(R.styleable.SettingItemLinearlayout_New_item_left);
        CharSequence text_right = typedArray.getText(R.styleable.SettingItemLinearlayout_New_item_right);
        boolean text_right_visibility = typedArray.getBoolean(R.styleable.SettingItemLinearlayout_New_item_right_text_visibility,
                false);
        boolean text_right_bg_visibility = typedArray.getBoolean(R.styleable.SettingItemLinearlayout_New_item_right_bg_visibility,
                false);

        if(text_right_visibility){
            textView_item_right.setVisibility(VISIBLE);
        }else {
            textView_item_right.setVisibility(INVISIBLE);
        }

        if (false == text_right_bg_visibility){
            textView_item_right.setBackground(null);
        }else {
            //如果显示背景，则字体修改为白色
            textView_item_right.setTextColor(0xF3FFFFFF);
        }


        if(TextUtils.isEmpty(text_left)){
            text_left = "设置项名称";
        }
//        if(TextUtils.isEmpty(text_right)){
//            text_right = "未绑定";
//        }
        textView_item_left.setText(text_left);
        textView_item_right.setText(text_right);

        typedArray.recycle();
    }

    public void setTextView_item_right(String text_right){
        textView_item_right.setText(text_right);
    }

    public void setTextView_item_left(String text_left){
        textView_item_right.setText(text_left);
    }

    public void setTextColor(){
        textView_item_right.setTextSize(TypedValue.COMPLEX_UNIT_DIP,14);
        textView_item_right.setTextColor(getContext().getResources().getColor(R.color.base_black_65));
    }

    public void shwoNewVersionFlag(){
        textView_item_right.setVisibility(VISIBLE);
        textView_item_right.setBackgroundResource(R.drawable.af_setting_bg_new);
        textView_item_right.setText("New");
    }

    public void showProgressBar(){
        progressBar.setVisibility(VISIBLE);
        textView_item_right.setText(R.string.acquiring_phone);
    }

    public void dissmissProgressBar(){
        progressBar.setVisibility(GONE);
    }

    public void dismissNewVersionFlag(){
        textView_item_right.setVisibility(INVISIBLE);
    }


//    @BindView(R.id.item_text_left)
    TextView textView_item_left;

//    @BindView(R.id.item_text_right)
    TextView textView_item_right;

//    @BindView(R.id.progressBar)
    ProgressBar progressBar;

    private void initView(Context context) {

        LayoutParams lp = new LayoutParams(
                LinearLayout.LayoutParams.MATCH_PARENT,  LinearLayout.LayoutParams.WRAP_CONTENT);
        mContainer = (RelativeLayout) LayoutInflater.from(context).inflate(
                R.layout.item_setting_fun, null);
        addView(mContainer, lp);
        textView_item_left = (TextView) mContainer.findViewById(R.id.item_text_left);
        textView_item_right = (TextView) mContainer.findViewById(R.id.item_text_right);
        progressBar = (ProgressBar)mContainer.findViewById(R.id.progressBar);
//        ButterKnife.bind(this, mContainer);

        //textView_item = (TextView) findViewById(R.id.item_setting_text);
    }
}
