package com.xdja.ckms.common.util;

import android.content.Context;

import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.util.DisplayMetrics;


import java.util.Locale;

/**
 * Created by guoyaxin on 2016/12/6.
 *  多语言存储类
 *  <br/>
 *  <br/>
 *  modify 2017年5月31日09:38:15 weizg 因为在Android N上，Locale.getDefault()的返回值，会受
    resources.updateConfiguration(config, dm)影响，并且getDefault()返回只是当前应用所在虚拟机的语言，非系统当前语言；
    现修改多语言设置为只有中文，英文两项，默认为中文；
    为了兼容之前版本已经保存的多语言配置信息，新增一个多语言配置文件，新版本从该文件中读取配置，如果新配置还未创建，则读取老配置文件。
 *
 */

public class LanguageSpUtils {

    private static final String lang_sp = "language";
    private static final String key_lang = "key_lang";

    //add 2017年5月31日10:47:13 weizg
    private static final String lang_new_sp = "language_new";

    /**
     * 获取应用采用的语言的索引
     * @param context
     * @return
     */
    public static int getLocalIndex(Context context){
        int localIndex;

        //modif 2017年5月31日10:52:52 weizg
        //为了兼容之前版本中已经保存的配置，这里首先读取新配置，如果尚未有，则读取老配置文件，并转换成新配置信息
        localIndex = getLocalIndexFromNewConfig(context);
        if(localIndex == -1){
            //尚未使用新配置问就保存语言首选项，则读取老配置文件
            int oldConfigIndex = getSharedPreferences(context).getInt(key_lang, 0);
            if(oldConfigIndex == 0){
                //之前配置的为跟随系统
                Locale currentlocale = Locale.getDefault();
                if(currentlocale.getLanguage().equals(Locale.SIMPLIFIED_CHINESE.getLanguage())){
                    //当前为简体中文
                    localIndex = 0;
                }else {
                    //其他语言一律为英文
                    localIndex = 1;
                }
            }else {
                //如果之前配置非默认语言选项，则index-1
                localIndex = oldConfigIndex - 1;
            }

        }

        return localIndex;

//        return getSharedPreferences(context).getInt(key_lang,0);
    }

    /**
     * 保存 切换的语言
     * @param context
     * @param local
     */
    private static void saveLocalIndex(Context context,int local){
//        SharedPreferences sharedPreferences =getSharedPreferences(context);
        //modify 2017年5月31日11:02:02 weizg 删除跟随系统后，配置信息保存到新文件中
        SharedPreferences sharedPreferences =getNewSharedPreferences(context);

        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(key_lang,local);
        editor.apply();
    }


    private static SharedPreferences getSharedPreferences(Context context){
        return context.getSharedPreferences(lang_sp,Context.MODE_PRIVATE);
    }


    //add 2017年5月31日10:48:14 weizg start
    /**
     * 获取应用采用的语言的索引
     * @param context
     * @return
     */
    private static int getLocalIndexFromNewConfig(Context context){
        return getNewSharedPreferences(context).getInt(key_lang,-1);
    }

    private static SharedPreferences getNewSharedPreferences(Context context){
        return context.getSharedPreferences(lang_new_sp,Context.MODE_PRIVATE);
    }

    //add 2017年5月31日10:48:14 weizg end

    /**
     * 保存设置选项 并 重新跳转到主页面
     * @param context
     * @param index
     */
    public static void saveSetting(Context context,int index){
        saveLocalIndex(context,index);
        restart(context);
    }

    private static void restart(Context context){
//        ActivityController.getInstance().popAllActivity();
//        String which = SharedPreferencesUtil.getWhichStartLanguageSettingActivity(context);
//        String isNoChipExist = SharedPreferencesUtil.getNoChipStartMainFragment(context);
//        Intent intent = null;
//        //判断是哪个activity启动的语言设置界面，由于语言设置完毕后需要关闭所有界面，
//	     //所以需要知道设置完毕后，跳转到哪个界面。
//        if(which.equals("MainFragmentPresenter")){
//            //如果改由没有芯片界面，跳转到主界面，然后设置的语言，则设置语言后，跳转到没有芯片界面
//            if(isNoChipExist.equals("NoChipPresenter")){
//                intent = new Intent(context, NoChipPresenter.class);
//            }else {
//                intent = new Intent(context, MainFragmentPresenter.class);
//            }
//        }else {
//             intent = new Intent(context, NoChipPresenter.class);
//        }
//        SharedPreferencesUtil.saveNoChipStartMainFragment(context,"");
//        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
//        context.startActivity(intent);
    }



    /**
     * 根据 设置选项，显示相应的语言
     */
    public static void changeLanguage(Context context){

        /*if (index ==1){
            locale =Locale.SIMPLIFIED_CHINESE;
        }else if (index ==2 || !(locale.equals(Locale.SIMPLIFIED_CHINESE)) ){
            locale = Locale.ENGLISH;
        }*/

        setLanguage(context,getAppSelectLocale(context));
    }

    /**
     * 设置语言
     * @param locale
     */
    private static void setLanguage(Context cxt,Locale locale) {
        Resources resources = cxt.getResources();
        DisplayMetrics dm = resources.getDisplayMetrics();
        Configuration config = resources.getConfiguration();
        // 应用用户选择语言
        config.locale = locale;
        resources.updateConfiguration(config, dm);
    }


    /**
     * 判断当前应用语言是否为中文
     * @return
     */
    public static boolean isZh(Context cxt){
        Locale local = cxt.getResources().getConfiguration().locale;
        return local.equals(Locale.SIMPLIFIED_CHINESE);
    }

    //add 2017年12月15日19:45:30 weizg
    //封装成方法，提供给其他类使用
    public static Locale getAppSelectLocale(Context context){
        int index = LanguageSpUtils.getLocalIndex(context);
        Locale locale = Locale.getDefault();

        //modify 2017年5月31日11:14:16 weizg
        if (index ==0){
            locale =Locale.SIMPLIFIED_CHINESE;
        }else if (index ==1 || !(locale.equals(Locale.SIMPLIFIED_CHINESE)) ){
            locale = Locale.ENGLISH;
        }

        return locale;
    }

}
