package com.xdja.ckms.common.util;

import android.content.Context;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class PropertyUtil {
    /**
     * 该方法从config.properties配置文件中读取参数
     * @param c
     * @param param 参数名称
     * @return
     */
    public static String getProperties(Context c, String param) {
        return getProperties(c,param,"config.properties");
    }

    /**
     * 该方法从指定文件中读取参数
     * @param c
     * @param param 参数名称
     * @param propertyFileName 配置文件名称
     * @return
     */
    public static String getProperties(Context c, String param, String propertyFileName) {
        Properties props = new Properties();
        try {
            InputStream in = c.getAssets().open(propertyFileName);
            BufferedReader bf = new BufferedReader(new InputStreamReader(in));
            props.load(bf);
        } catch (Exception e1) {
            // TODO Auto-generated catch block
            e1.printStackTrace();
        }
        return props.getProperty(param);
    }
}
