package com.xdja.ckms.common.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.util.Log;

/**
 * 保存，读取配置信息类
 * @author wzg
 *
 */
public class SharedPreferencesUtil {

    public static final int IS_NEED_UPDATE_CONFIG = -1;
    public static final int UN_NEED_UPDATE_CONFIG = 1;

	public static final String PERMISSION_DIALOG_STATE_SHOW = "show";
	public static final String PERMISSION_DIALOG_STATE_NOT_SHOW = "not_show";
	public static final String DEFAUL_PHONE_IF_NOT_FIND = "not_find";
	public static final boolean DEFAUL_IS_UNLOCK = false;

	public static final int DEFAUL_COMMIT_TIME = 0;


	private static final String BLUETOOTH_KEY_INFO = "bluetooth_key_info";
	private static final String BLUETOOTH_KEY = "bluetooth_key";
	private static final String TF_CARD = "tf_card";
	private static final String CHIP_PARAM = "chip_param";
	private static final String VERIFY_PIN_FIRST_TIME  = "verify_pin_first_time"; //是否是第一次弹 验证安全口令 弹框 gyx 2017.7.12
	private static final String LOCATION_PERMESSION = "location_permission" ;     //位置权限
	//判断是哪个activity启动的语言设置界面，由于语言设置完毕后需要关闭所有界面，所以需要知道设置完毕后，跳转到哪个界面。
	private static final String START_LANGUAGE_SETTING_ACTIVITY = "start_language_setting_activity";

	private static final String NO_CHIP_PREFERENCES = "no_chip_preferences";



	/**
	 * 设置客户端状态为未明确退出
	 * @param context
	 * @since 2013-7-4 weizg
	 */
	public static void setAppLoginOk(Context context){
		SharedPreferences sp = context.getSharedPreferences("userconfig",
				Context.MODE_PRIVATE);
		sp.edit().putString("logstate", "login").commit();
	}
	
	/**
	 * 设置客户端状态为已退出
	 * @param context
	 * @since 2013-7-4 weizg
	 */
	public static void setAppExit(Context context){
		SharedPreferences sp = context.getSharedPreferences("userconfig",
				Context.MODE_PRIVATE);
		sp.edit().putString("logstate", "exit").commit();
	}
	
	/**
	 * 客户端是否明确退出
	 * @param context
	 * @return
	 * @since 2013-7-4 weizg
	 */
	public static boolean isAppExit(Context context){
		SharedPreferences sp = context.getSharedPreferences("userconfig",
				Context.MODE_PRIVATE);
		String logstate = sp.getString("logstate", "exit");
		
		if("exit".equals(logstate)){
			return true;
		}else{
			return false;
		}
	}

	public static void saveTfID(Context con, String cardid) {
		SharedPreferences sp = con.getSharedPreferences("userinfo",
				Context.MODE_PRIVATE);
		sp.edit().putString("cardid", cardid).commit();

	}

	public static String readTfId(Context con) {
		SharedPreferences sp = con.getSharedPreferences("userinfo",
				Context.MODE_PRIVATE);
		String username = sp.getString("cardid", null);
		return username;
	}

	public static void saveCardSN(Context con, String cardid) {
		SharedPreferences sp = con.getSharedPreferences("userinfo",
				Context.MODE_PRIVATE);
		sp.edit().putString("cardsn", cardid).commit();

	}

	public static String readCardSN(Context con) {
		SharedPreferences sp = con.getSharedPreferences("userinfo",
				Context.MODE_PRIVATE);
		String username = sp.getString("cardsn", null);
		return username;
	}

	public static void saveFirstLogin(Context con, String state) {
		SharedPreferences sp = con.getSharedPreferences("first",
				Context.MODE_PRIVATE);
		sp.edit().putString("state", state).commit();
	}

	public static String readFirstLogin(Context con) {
		SharedPreferences sp = con.getSharedPreferences("first",
				Context.MODE_PRIVATE);
		String username = sp.getString("state", null);
		return username;
	}

	/**
	 * 有升级版本标志
	 * @param context
     */
	public static void setUpdateVersionFlag(Context context){
		SharedPreferences sp = context.getSharedPreferences("userconfig",
				Context.MODE_PRIVATE);
		sp.edit().putString("update_ver", "true").commit();
	}

	/**
	 * 有升级版本标志
	 * @param context
	 */
	public static String getUpdateVersionFlag(Context context){
		SharedPreferences sp = context.getSharedPreferences("userconfig",
				Context.MODE_PRIVATE);
		return sp.getString("update_ver", "false");
	}

	/**
	 * 有升级版本标志用来控制主界面设置按钮状态
	 * @param context context
     */
	public static void setUpdateVersionFlagForMainView(Context context,boolean flag){
		SharedPreferences sp = context.getSharedPreferences("userconfig",
				Context.MODE_PRIVATE);
		sp.edit().putString("new_version", flag+"").commit();
	}

	/**
	 * 有升级版本标志用来控制主界面设置按钮状态
	 * @param context context
	 */
	public static String getUpdateVersionFlagForMainView(Context context){
		SharedPreferences sp = context.getSharedPreferences("userconfig",
				Context.MODE_PRIVATE);
		return sp.getString("new_version", "false");
	}
	/**
	 * 清空有升级版本标志
	 * @param context context
	 */
	public static void clearUpdateVersionFlag(Context context){
		SharedPreferences sp = context.getSharedPreferences("userconfig",
				Context.MODE_PRIVATE);
		sp.edit().putString("update_ver", "false").commit();
	}

	public static void savePermissionDialogShowState(Context con, String state) {
		SharedPreferences sp = con.getSharedPreferences("first",
				Context.MODE_PRIVATE);
		sp.edit().putString("permisson_show_state", state).commit();
	}

	public static String readPermissionDialogShowState(Context con) {
		SharedPreferences sp = con.getSharedPreferences("first",
				Context.MODE_PRIVATE);
		return sp.getString("permisson_show_state", PERMISSION_DIALOG_STATE_SHOW);
	}

	/**
	 * 保存绑定的手机号
	 * @param context context
	 * @param num 手机号
	 * @param cardId 卡id
     */
	public static void saveBindingPhoneNum(Context context,String num, @NonNull String cardId){
		SharedPreferences sp = context.getSharedPreferences("binding_phone_num",Context.MODE_PRIVATE);
		sp.edit().putString(getPhoneKey(cardId),num).commit();
	}

	/**
	 * 查找绑定的手机号
	 * @param context context
	 * @param cardId 卡id
	 * @return 查询结果；如果未找到，则返回“not_find”
     */
	public static String getBindingPhoneNum(Context context, @NonNull String cardId){
		SharedPreferences sp = context.getSharedPreferences("binding_phone_num",Context.MODE_PRIVATE);
		return sp.getString(getPhoneKey(cardId), DEFAUL_PHONE_IF_NOT_FIND);
	}

	private static String getPhoneKey(String cardId){
		return cardId.toUpperCase() + KEY_phone_TAG;
	}


	/**
	 * 获取授权码提交时间
	 * @param context
	 * @return
     */
	public static long getResetCodeCommitTime(Context context){
		SharedPreferences sp = context.getSharedPreferences("authorized_code",Context.MODE_PRIVATE);
		return sp.getLong("commit_time",DEFAUL_COMMIT_TIME);
	}

	/**
	 * 设置授权码提交时间
	 * @param context
	 * @param time
     */
	public static void setResetCodeCommitTime(Context context,long time){
		SharedPreferences sp = context.getSharedPreferences("authorized_code",Context.MODE_PRIVATE);
		sp.edit().putLong("commit_time",time).apply();
	}



	/**
	 * 清空授权页面相关展示信息
	 */
	public static void clearResetTime(Context cxt){
		setResetCodeCommitTime(cxt,DEFAUL_COMMIT_TIME);
	}

	/**
	 * 设置解锁授权码提交时间
	 * @param context
	 * @param time
	 */
	public static void setUnlockResetCodeCommitTime(Context context,long time){
		SharedPreferences sp = context.getSharedPreferences("authorized_code",Context.MODE_PRIVATE);
		sp.edit().putLong("unlock_commit_time",time).apply();
	}

	public static long getUnlockResetCodeCommitTime(Context context){
		SharedPreferences sp = context.getSharedPreferences("authorized_code",Context.MODE_PRIVATE);
		return sp.getLong("unlock_commit_time",DEFAUL_COMMIT_TIME);
	}

	public static void clearUnlockResetTime(Context context){
		setUnlockResetCodeCommitTime(context,DEFAUL_COMMIT_TIME);
	}

	/**
	 * 设置是否是安全芯片解锁项
	 * @param context
	 * @param isUnlockChip
     */
    public static void setIsUnlockChip(Context context,boolean isUnlockChip){
		SharedPreferences sp = context.getSharedPreferences("unlock_chip",Context.MODE_PRIVATE);
		sp.edit().putBoolean("is_unlock_chip",isUnlockChip).apply();
	}

	/**
	 * 获取是否是安全芯片解锁项
	 * @param context
	 * @return
     */
	public static boolean getIsUnlockChip(Context context){
		SharedPreferences sp = context.getSharedPreferences("unlock_chip",Context.MODE_PRIVATE);
		return sp.getBoolean("is_unlock_chip",DEFAUL_IS_UNLOCK);
	}



	/**
	 * 记录用户是否阅读并同意使用存款
	 * @param context
     */
	public static void saveHaveReadAndAgree(Context context){
		SharedPreferences sp = context.getSharedPreferences("have_read_and_agree",Context.MODE_PRIVATE);
		sp.edit().putBoolean("agree",true).commit();
	}

	/**
	 * 查找用户是否已经阅读并同意使用条款
	 * @param context
	 * @return
     */
	public static boolean getIsHaveReadAndAgree(Context context){
		SharedPreferences sp = context.getSharedPreferences("have_read_and_agree",Context.MODE_PRIVATE);
		return sp.getBoolean("agree",false);
	}
	/**
	 * 记录用户是否绑定成功
	 * @param context
     */
	public static void saveIsBinDingSuccess(Context context){
		SharedPreferences sp = context.getSharedPreferences("is_binding_success",Context.MODE_PRIVATE);
		sp.edit().putBoolean("is_success",true).commit();
	}

	/**
	 * 记录用户是否绑定成功
	 * @param context
	 * @return
     */
	public static boolean getIsBinDingSuccess(Context context){
		SharedPreferences sp = context.getSharedPreferences("have_read_and_agree",Context.MODE_PRIVATE);
		return sp.getBoolean("is_success",false);
	}

	/**
	 * 记录是否稍后提醒绑定身份信息
	 * @param context
     */
	public static void saveDoNotRemindLater(Context context){
		SharedPreferences sp = context.getSharedPreferences("remind_later",Context.MODE_PRIVATE);
		sp.edit().putBoolean("remind",true).commit();
	}

	/**
	 * 记录是否稍后提醒绑定身份信息
	 * @param context
	 * @return
     */
	public static boolean getDoNotRemindLater(Context context){
		SharedPreferences sp = context.getSharedPreferences("remind_later",Context.MODE_PRIVATE);
		return sp.getBoolean("remind",false);
	}

	//modify 2017年7月25日11:01:45 weizg 为了适配多芯片模式，本地保存解锁，重置usn码改造为
	//根据cardId保存 start
	private static final String KEY_RESET_USN = "RESET_USN";
	private static final String KEY_UNLOCK_USN = "UNLOCK_USN";
	private static final String KEY_RESET_TAG = "_RST";
	private static final String KEY_UNLOCK_TAG = "_ULK";
	private static final String USN_SP_NAME = "SAVE_USN";
	public static final String DEFAULT_USN = "";
	private static final String RECOVERY_RESULT = "recovery_success";
	private static final boolean RECOVERY_DEFAULT = false;
	private static final String RECOVERY_COMPLETE = "recovery_complete";
	private static final String COS_UPDATE_STATUS = "cos_update_status";
	private static final String ALL_CHIP_INFO = "all_chip_info";
	private static final String SHOW_TOP_LAYOUT = "show_top_layout";

	//modify 2017年8月17日11:31:09 weizg 为了适配多芯片模式，本地保存绑定的手机新增cardid条件
	private static final String KEY_phone_TAG = "_phone_num";

//	private


    /**
	 * 保存重置对应的动态码；为适配多芯片，key值中保存了芯片id的信息
	 * @param cxt 上下文变量
	 * @param cardId 芯片id
	 * @param usn 动态标识码
     */
	public static void saveResetUSN(Context cxt,String cardId, String usn){
          SharedPreferences sp = getUSNSharedPreferences(cxt);

          //key为：{cardId}_RST
		  sp.edit().putString(getSPResetKey(cardId),usn).apply();
	}

	/**
	 * 获取重置对应的动态码;为适配多芯片，key值中保存了芯片id的信息
	 * @param cxt 上下文变量
	 * @param cardId 芯片id
	 */
	public static String getResetUSN(Context cxt, String cardId){
		SharedPreferences sp = getUSNSharedPreferences(cxt);
		//key为：{cardId}_RST
        return sp.getString(getSPResetKey(cardId),DEFAULT_USN);
	}

	private static String getSPResetKey(String cardId){
		return cardId.toUpperCase() + KEY_RESET_TAG;
	}

	/**
	 * 保存解锁对应的动态码；为适配多芯片，key值中保存了芯片id的信息
	 * @param cxt 上下文变量
	 * @param cardId 芯片id
	 * @param usn 动态标识码
	 */
	public static void saveUnLockUSN(Context cxt,String cardId, String usn){
		SharedPreferences sp = getUSNSharedPreferences(cxt);

		//key为：{cardId}_ULK
		sp.edit().putString(getSPUnlockKey(cardId),usn).apply();
	}

	/**
	 * 获取解锁对应的动态码
	 * @param cxt 上下文变量
	 * @param cardId 芯片id
	 */
	public static String getUnlockUSN(Context cxt, String cardId){
		SharedPreferences sp = getUSNSharedPreferences(cxt);

		//key为：{cardId}_ULK
		return sp.getString(getSPUnlockKey(cardId),DEFAULT_USN);
	}

	private static String getSPUnlockKey(String cardId){
		return cardId.toUpperCase() + KEY_UNLOCK_TAG;
	}

	//modify 2017年7月25日11:01:45 weizg 为了适配多芯片模式，本地保存解锁，重置usn码改造为
	//根据cardId保存 end

	/**
	 * 存储恢复完成的结果
	 * @param context
	 * @param result
     */
	public static void saveRecoveryResult(Context context,boolean result){
		SharedPreferences sp = getRecoverySharePerences(context);
		sp.edit().putBoolean(RECOVERY_COMPLETE,result);
	}



	/**
	 * 查询是否
	 * @param context
	 * @return
     */
	public static boolean getRecoveryResult(Context context){
		SharedPreferences sp = getRecoverySharePerences(context);
		return sp.getBoolean(RECOVERY_COMPLETE,RECOVERY_DEFAULT);
	}

	private static SharedPreferences getUSNSharedPreferences(Context cxt){
		return cxt.getSharedPreferences(USN_SP_NAME,Context.MODE_PRIVATE);
	}
	private static SharedPreferences getRecoverySharePerences(Context context){
		return context.getSharedPreferences(RECOVERY_RESULT,Context.MODE_PRIVATE);
	}

	private static SharedPreferences getCosUpdateStatusSharedPreferences(Context context){
		return context.getSharedPreferences(COS_UPDATE_STATUS,Context.MODE_PRIVATE);
	}

	private static SharedPreferences getAllChipInfoSharedPreferences(Context context){
		return context.getSharedPreferences(ALL_CHIP_INFO,Context.MODE_PRIVATE);
	}
	public static SharedPreferences getShowTopLayoutStateSharedPreferences(Context context){
		return context.getSharedPreferences(SHOW_TOP_LAYOUT,Context.MODE_PRIVATE);

	}
	private static SharedPreferences getBluetoothKeyharedPreferences(Context cxt){
		return cxt.getSharedPreferences(BLUETOOTH_KEY,Context.MODE_PRIVATE);
	}

	private static SharedPreferences getLocationPermissionSP(Context cxt){
		return cxt.getSharedPreferences(LOCATION_PERMESSION,Context.MODE_PRIVATE);
	}

	/**
	 * 是否是第一次 弹验证Pin 弹框的标志
	 * @param cxt
	 * @return
	 */
	private static SharedPreferences getVerifyPinDialogPreferences(Context cxt){
		return cxt.getSharedPreferences(VERIFY_PIN_FIRST_TIME,Context.MODE_PRIVATE);
	}


	private static SharedPreferences getChipParamPreferences(Context context){
		return context.getSharedPreferences(CHIP_PARAM,Context.MODE_PRIVATE);
	}

	private static SharedPreferences getNoChipPrefrences(Context context){
		return context.getSharedPreferences(NO_CHIP_PREFERENCES,Context.MODE_PRIVATE);
	}

	/**
	 * 此方法用于记录没有芯片界面跳转到主界面这一步骤，用于跳转到主界面后，设置语言后，跳转到没有芯片界面。
	 * @param context
	 * @param name
	 */
	public static void saveNoChipStartMainFragment(Context context,String name ){
		getNoChipPrefrences(context).edit().putString("startMainFragmentPresenter",name).commit();
	}

	public static String getNoChipStartMainFragment(Context context){
		return getNoChipPrefrences(context).getString("startMainFragmentPresenter","");
	}

	/**
	 * 判断是哪个activity启动的语言设置界面，由于语言设置完毕后需要关闭所有界面，
	 * 所以需要知道设置完毕后，跳转到哪个界面。
	 * @param context
	 * @return
	 */
	private static SharedPreferences getActivitySharedPreferences(Context context){
		return context.getSharedPreferences(START_LANGUAGE_SETTING_ACTIVITY,Context.MODE_PRIVATE);
	}

	public static void saveWhichStartLanguageSettingActivity(Context context,String className){
		getActivitySharedPreferences(context).edit().putString("which_activity",className).commit();
	}

	public static String getWhichStartLanguageSettingActivity(Context context){
		return getActivitySharedPreferences(context).getString("which_activity","");
	}


	public static void saveChipParam(Context context,String info){
		getChipParamPreferences(context).edit().putString("chip_param",info).commit();
	}

	public static String getChipParam(Context context){
		return getChipParamPreferences(context).getString("chip_param","");
	}


	private static final String STATUS = "status";

	/**
	 * 展示顶部提示栏
	 * @param context
	 */
	public static void saveShowTopLayoutState(Context context,boolean isShow){
		getShowTopLayoutStateSharedPreferences(context).edit().putBoolean("top_layout",isShow).commit();
	}

	public static boolean getShowTopLayoutState(Context context){
		return getShowTopLayoutStateSharedPreferences(context).getBoolean("top_layout",false);

	}
	/**
	 * 共四个状态
	 * 1.COS_NEED_UPDATE 升级第一阶段，检测到0305
	 * 2.COS_UPDATE_ING 第二阶段，正在升级
	 * 3.COS_UPDATE_COMPELETE 第二阶段升级完成
	 * 4.COS_UDPATE_FAIL 第二阶段升级失败
	 * 5.COS_RECOVERY_TO_NRMAL 第二阶段升级成功后，重启后为normal
	 * 非0305状态
	 * @param context
	 * @param status
     */
	public static void saveCosUpdateStatus(Context context,int status){
		SharedPreferences cosUpdateStatusSharedPreferences = getCosUpdateStatusSharedPreferences(context);
		boolean commit = cosUpdateStatusSharedPreferences.edit().putInt(STATUS, status).commit();
		Log.v("--saveCosUpdateStatus--","status: " + status );
		Log.v("--saveCosUpdateStatus--",String.valueOf(commit));
	}
	public static int getCosUpdateStatus(Context context){
		return getCosUpdateStatusSharedPreferences(context).getInt(STATUS,-5);
	}

	/**
	 * 保存 蓝牙Key 地址 和 cardId
	 * @param context
	 * @param info
	 */
	public static void saveBluetoothKey(Context context,String info){
        getBluetoothKeyharedPreferences(context).edit().putString(BLUETOOTH_KEY_INFO, info).apply();
	}

	/**
	 * 获取所有  蓝牙Key 信息
	 * @param context
	 * @return
	 */
	public static String getBluetoothKeyInfo(Context context){
		return getBluetoothKeyharedPreferences(context).getString(BLUETOOTH_KEY_INFO, "");
	}

	public static void saveTfInfo(Context context,String tfId){
		SharedPreferences sharedPreferences = getAllChipInfoSharedPreferences(context);
		sharedPreferences.edit().putString("tf_info",tfId).commit();
	}

	public static String getTfInfo(Context context){
		return getAllChipInfoSharedPreferences(context).getString("tf_info","");
	}

	public static void saveCoverCardInfo(Context context,String coverCardId){
		SharedPreferences allChipInfoSharedPreferences = getAllChipInfoSharedPreferences(context);
		allChipInfoSharedPreferences.edit().putString("cover_card_info",coverCardId).commit();
	}

	public static String getCoverCardInfo(Context context){
		return getAllChipInfoSharedPreferences(context).getString("cover_card_info","");
	}

	/**
	 * 获取是否是  第一次显示验证安全口令 弹框
	 * @param context
	 * @return
	 */
	public static boolean getIsVerifyPinFirst(Context context){
		return getVerifyPinDialogPreferences(context).getBoolean(VERIFY_PIN_FIRST_TIME,true);
	}

	/**
	 * 设置 不是  第一次显示验证安全口令 弹框
	 * @param context
	 */
	public static void setVerifyPinNotFirst(Context context){
		getVerifyPinDialogPreferences(context).edit().putBoolean(VERIFY_PIN_FIRST_TIME,false).apply();
	}


	private static String KEY_LOCATION = "key_location";

	/**
	 * 获取是否申请过 位置 权限
	 * @param context
	 */
	public static boolean getIsLocationPermissionRequest(Context context){
		return getLocationPermissionSP(context).getBoolean(KEY_LOCATION,false);
	}

	public static void setLocationRequested(Context context,boolean isRequested){
		getLocationPermissionSP(context).edit().putBoolean(KEY_LOCATION,isRequested).apply();
	}

}
