package com.xdja.ckms.common.util;

import android.Manifest;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.database.Observable;
import android.graphics.Rect;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;

import com.xdja.ckms.common.ActivityController;

import java.io.FileNotFoundException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import android.Manifest;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;

//import com.google.gson.reflect.TypeToken;
//import com.xdja.SafeKey.JNIAPI;
//import com.xdja.ckms.common.ActivityController;
//import com.xdja.ckms.common.util.LogUtil;
//import com.xdja.safekeyjar.XDJASafeTF;
//import com.xdja.scservice.R;
//import com.xdja.scservice.bean.ChipIsExistBean;
//import com.xdja.scservice.chip.AppChipParam;
//import com.xdja.scservice.chip.ChipOperate;
//import com.xdja.scservice.https.GsonUtil;
//import com.xdja.scservice.view.ToastCommon;
//import com.xdja.scservie_data.entity.DataConstDef;
//import com.xdja.scservie_data.utils.GetValueFromProperties;
//import com.xdja.util.PermissionBean;
//import com.xdja.util.PermissionUtil;

import java.io.FileNotFoundException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

//import static com.xdja.safekeyservice.SafeKeyApi.context;

/**
 * 通用方法类
 * Created by weizg on 2016/2/24.
 */
public class Utils {

    public static boolean isNetworkConnected(Context context) {
        if (context != null) {
            ConnectivityManager mConnectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
            NetworkInfo mNetworkInfo = mConnectivityManager.getActiveNetworkInfo();
            if (mNetworkInfo != null) {

                return mNetworkInfo.isAvailable();
            }
        }
        return false;
    }

    /**
     * 显示输入面板
     * 此方法用于界面弹不出来键盘时使用,因界面绘制有延迟,所以有些情况下键盘无法弹出
     *
     * @param context
     * @param v
     */
    public static void keyboardDelay(final Context context, final View v, final boolean isShow) {
        if (context == null) {
            return;
        }
        Timer timer = new Timer();
        timer.schedule(new TimerTask() {
            @Override
            public void run() {
                InputMethodManager imm = (InputMethodManager) context.getSystemService(Context.INPUT_METHOD_SERVICE);
                if (isShow) {
                    imm.showSoftInput(v, 0);
                } else {
                    imm.hideSoftInputFromWindow(v.getApplicationWindowToken(), 0);
                }
            }
        }, 500);

    }

    /**
     * 显示输入面板
     * 此方法用于界面弹不出来键盘时使用,因界面绘制有延迟,所以有些情况下键盘无法弹出
     *
     * @param context
     */
    public static void showInputWindowDelay(final Activity context) {
        if (context == null) {
            return;
        }

        //modify 2017年9月15日10:50:45 weizg
        //海信测试出，下面的getWindowVisibleDisplayFrame执行是有空指针异常
        try{
            Timer timer = new Timer();
            timer.schedule(new TimerTask() {
                @Override
                public void run() {
                    Rect rect = new Rect();
                    Activity decorView = (Activity) context;
                    decorView.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);

                    int displayHight = rect.bottom - rect.top;
                    int hight = decorView.getWindow().getDecorView().getRootView().getHeight();
                    boolean visible = (double) displayHight / hight < 0.8;

                    if (visible) {
                        LogUtil.getUtils().d("软键盘出现");
                    } else {
                        LogUtil.getUtils().d("软键盘没有出现,即将弹出软键盘");
                        InputMethodManager imm = (InputMethodManager) context.getSystemService(Context.INPUT_METHOD_SERVICE);
                        //imm.toggleSoftInput(0*//*InputMethodManager.SHOW_FORCED*//*, InputMethodManager.HIDE_NOT_ALWAYS);
                        imm.toggleSoftInput(InputMethodManager.SHOW_IMPLICIT, InputMethodManager.HIDE_IMPLICIT_ONLY);
                        //imm.toggleSoftInput(0, InputMethodManager.HIDE_NOT_ALWAYS);
                    }

                }
            }, 500);

        }catch (Exception e){
            e.printStackTrace();
        }

    }

    /**
     * 用于隐藏输入法
     *
     * @param context
     */
    public static void hideInputWindowDelay(final Context context) {
        if (context == null) {
            return;
        }
        Rect rect = new Rect();
        Activity decorView = (Activity) context;
        decorView.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);

        int displayHight = rect.bottom - rect.top;
        int hight = decorView.getWindow().getDecorView().getRootView().getHeight();
        boolean visible = (double) displayHight / hight < 0.8;

        if (visible) {
            InputMethodManager imm = (InputMethodManager) context.getSystemService(Context.INPUT_METHOD_SERVICE);
            imm.toggleSoftInput(0, InputMethodManager.HIDE_NOT_ALWAYS);
        }
    }

    /**
     * 判断当前界面输入法是否弹出
     *
     * @param context
     * @return
     */
    public static boolean isKeyboardShown(Context context) {
        if (context == null) {
            return false;
        }
        Rect rect = new Rect();
        Activity decorView = (Activity) context;
        decorView.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);

        int displayHight = rect.bottom - rect.top;
        int hight = decorView.getWindow().getDecorView().getRootView().getHeight();
        boolean visible = (double) displayHight / hight < 0.8;
        return visible;
    }

    /**
     * 获取隐藏显示的手机号
     *
     * @param number
     * @return
     */
    public static String getHidenNumber(String number) {

        //add 2017年4月7日17:07:14 weizg
        if(TextUtils.isEmpty(number)){
            return "";
        }

        return number.substring(0, 3) + "****" + number.substring(7, number.length());
    }

    /**
     * 在字符串中添加分隔符
     *
     * @param srcStr   原字符串
     * @param seprator 分隔符
     * @param count    间隔几个字符加分隔符
     * @return 处理后的字符串
     */
    public static String appendSeprator(String srcStr, String seprator, int count) {
        StringBuffer sb = new StringBuffer(srcStr);
        int index = count;
        while (sb.length() > count && index < sb.length() - 1) {
            sb.insert(index, seprator);
            index += count + 1;
        }
        return sb.toString();
    }

    public static boolean regExString(String string, String regEx) {
        //String reg = //"[a-zA-Z0-9]{2}#[0-9]{15}#[a-z0-9]{6}";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    /**
     * 判断当前app是否处于后台
     * @param context
     * @return 在后台返回true 不在后台返回false
     */
    public static boolean isBackground(Context context) {
        ActivityManager activityManager = (ActivityManager) context
                .getSystemService(Context.ACTIVITY_SERVICE);
        List<ActivityManager.RunningAppProcessInfo> appProcesses = activityManager
                .getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (appProcess.processName.equals(context.getPackageName())) {
                Log.i(context.getPackageName(), "此appimportace ="
                        + appProcess.importance
                        + ",context.getClass().getName()="
                        + context.getClass().getName());
                if (appProcess.importance != ActivityManager.RunningAppProcessInfo.IMPORTANCE_FOREGROUND) {
                    Log.i(context.getPackageName(), "处于后台"
                            + appProcess.processName);
                    return true;
                } else {
                    Log.i(context.getPackageName(), "处于前台"
                            + appProcess.processName);
                    return false;
                }
            }
        }
        return false;
    }

    /**
     * 恢复记录标准格式
     * 根据时间毫秒书转化成规定格式的时间
     * @param dateLong
     * @return
     */
    public static String getForamtData(@NonNull long dateLong) {
        Date date = new Date(dateLong);
        DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return format.format(date);
    }

    /**
     * 判断传入的字符串是否全是数字
     * @param str
     * @return true  全是数字
     *         false 不全是数字
     */
    public static boolean isNum(@NonNull String str){
        String reg = "[0-9]+";
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    /**
     * 判断是不是海信手机
     * 暂时只能分辨三款机型：Hisense E76,Hisense C20S，Hisense E76mini
     * @return
     */
    public static boolean isHisencePhone(){
        String phone = android.os.Build.MODEL.replaceAll(" ","").toLowerCase();
        if(phone.equals("hisensee76") || phone.equals("hisensec20s") || phone.equals("hisensee76mini")
                || phone.equals("hisensep1")){
            return true;
        }
        return false;
    }

    /**
     * 判断是不是这类手机：在测试过程中，发现部分机型(Android系统在6.0之前，不包括6.0)当前TF卡被拔出后，会把当前运行的已经打开TF卡上文件的应用，强制
     * kill，然后再重启进程，但是这种重启很多情况是没有调用应用的application的oncreate方法，会导致一些初始化工作
     * 没有做，从而引起界面的异常。故针对这些手机芯片管家在前台则直接全部关闭界面
     *
     * @return true
     */
    public static boolean isDevKillAppWhenTFRemove(){
        //modify 2017年8月9日11:49:41 weizg 测试发现在中兴的C2017（Android6.0）上当tf被拔出时，且芯片管家在
        //前台显示，系统也会把芯片管家kill并重启停留界面；为了兼容，针对中兴手机也做kill的处理

//        return Build.VERSION.SDK_INT < Build.VERSION_CODES.M ||  isZTEDev();

        //modify 2017年8月9日14:25:32 weizg 为了各自系统UI效果一直，现在统一显示效果：
        //TF拔出时，如果是芯片管家前台显示，则主动关闭所有界面，通知栏和toast提示
        return true;

        /*String phone = Build.MODEL.replaceAll(" ","").toLowerCase();

        Log.d("utils", "phone model: " + phone);

        return "m2note".equalsIgnoreCase(phone) || "htcm8t".equalsIgnoreCase(phone);*/
    }

    private static boolean isZTEDev(){
        String phone = Build.MODEL.replaceAll(" ","").toLowerCase();

        Log.d("utils", "phone model: " + phone);

        return phone.contains("zte");
    }

    /**
     * 是否在主界面显示备份恢复
     * @param context
     * @return
     */
//    public static boolean isShowBackupRestore(Context context) {
//        String filePath = "config.properties";
//        String keyNet = "showBackupRestore";
//        String str = "";
//        try {
//            str = GetValueFromProperties.getValue(context, filePath, keyNet);
//        } catch (FileNotFoundException e) {
//            e.printStackTrace();
//        }
//        if ("false".equals(str)) {
//            return false;
//        } else {
//            return true;
//        }
//    }


    /**
     * 从配置文件中读取是否显示备份恢复界面入口配置项
     * @return true 隐藏；false 不隐藏
     */
//    public static boolean isHideBackupRestoreUI(Context context){
//        boolean isHide = false;
//
//        ConfigPropertyUtil configPropertyUtil = new ConfigPropertyUtil(context.getApplicationContext());
//        Map<String, String> configMap = configPropertyUtil.get();
//
//        if(configMap != null){
//
//            String showTag = configMap.get(DataConstDef.HIDE_BACKUPRESTORE);
//
//            if("true".equals(showTag)){
//                isHide = true;
//            }
//        }
//
//        return isHide;
//    }

    /**
     * 是否执行证书上报流程
     * @return true 执行；false 不执行
     */
//    public static boolean isExeUploadCer(Context context){
//        boolean isExe = false;
//
//        ConfigPropertyUtil configPropertyUtil = new ConfigPropertyUtil(context.getApplicationContext());
//        Map<String, String> configMap = configPropertyUtil.get();
//
//        if(configMap != null){
//
//            String showTag = configMap.get(DataConstDef.UPLOAD_INFO_TRIGGER);
//
//            if("true".equals(showTag)){
//                isExe = true;
//            }
//        }
//
//        return isExe;
//    }


    /**
     * 程序是否在前台运行
     *
     * @return
     */
//    public static boolean isAppOnForeground(Context context) {
//
//        int currentVersion = Build.VERSION.SDK_INT;
//        if(currentVersion<=19){
//            return isAppOnForegroundWithVersion();
//        }else {
//            //modify 2016年12月20日19:43:08 weizg  修改为使用下面方法
//            return isAppOnForeground2(context);
//        }
//    }

    /**
     * 系统版本在4.4以下，此方法可以正常判断
     * @return
     */
//    public static boolean isAppOnForegroundWithVersion(){
//        ActivityManager am = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
//        List<ActivityManager.RunningTaskInfo> tasks = am.getRunningTasks(1);
//        if (tasks!=null && !tasks.isEmpty()) {
//            ComponentName topActivity = tasks.get(0).topActivity;
//            if(topActivity!=null ){
//                if (topActivity.getPackageName().equals(context.getPackageName())) {
//                    return true;
//                }
//            }
//        }
//        return false;
//    }

    /**
     * 判断当前进程是否为前台进程<br>
     *     使用<code>ActivityManager</code>的<code>getRunningAppProcesses</code>方法来判断是为前台进程；
     *     但根据stackoverflow上一个问题描述，如此判断是不可靠的，不保存能适配到所有情况，因为getRunningAppProcesses方法
     *     不是设计来处理这个场景的。<br>
     *     <p>参考资料如下</p>
     *     <pre>
     *    Checking if an Android application is running in the background
     http://stackoverflow.com/questions/3667022/checking-if-an-android-application-is-running-in-the-background/5862048#5862048

     check android application is in foreground or not?
     http://stackoverflow.com/questions/8489993/check-android-application-is-in-foreground-or-not
     *     </pre>
     * @param context 环境变量
     * @return true --前台；false -- 非前台
     * @since 2016年12月20日19:25:10 weizg
     *
     *
     * 系统版本大于4.4，此方法可以正常判断。
     */
    public static boolean isAppOnForeground2(Context context){
        ActivityManager activityManager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);

        List<ActivityManager.RunningAppProcessInfo> runningAppProcesses = activityManager.getRunningAppProcesses();

        if(runningAppProcesses == null){
            return false;
        }

        final String packageName = context.getPackageName();
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : runningAppProcesses){
            if(runningAppProcessInfo.importance == ActivityManager.RunningAppProcessInfo.IMPORTANCE_FOREGROUND
                    && runningAppProcessInfo.processName.equals(packageName)){
                return true;
            }

        }

        return false;
    }

//    public static String getSecondActivity(Activity context){
//        ActivityManager manager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
//        List<ActivityManager.RunningTaskInfo> runningTasks = manager.getRunningTasks(1);
//        if(runningTasks != null){
//            return (runningTasks.get(0).topActivity);
//        }

//    }

    static long exitTime;
//    public static boolean exit(Context context) {
//        if (System.currentTimeMillis() - exitTime > 2000) {
//            ToastCommon.makeText(context, R.string.click_agin_exit);
//            exitTime = System.currentTimeMillis();
//            return false;
//        } else {
//            NotificationUtil.clearNotification(context);
//            ActivityController.getInstance().exit();
//            return true;
//        }
//    }

    /**
     * 恢复关联启动组装提示语
     * @param appName
     * @return
     */
//    public static String buildContent(String appName){
//        StringBuilder builder = new StringBuilder();
//        builder.append(context.getResources().getString(R.string.recovery_dialog_text1));
//        builder.append(appName);
//        builder.append(context.getResources().getString(R.string.recovery_dialog_text2));
//        return builder.toString();
//    }
    /**
     * 导航栏组装提示语
     * @param num
     * @return
     */
//    public static String buildTopTipContent(int num){
//        StringBuilder builder = new StringBuilder();
//        builder.append(context.getResources().getString(R.string.how_many_chips_text1));
//        builder.append(String.valueOf(num));
//        builder.append(context.getResources().getString(R.string.how_many_chips_text2));
//        return builder.toString();
//    }

    public static int pinRole = 0x11;

    /**
     * 判断芯片是否锁死
     * @return
     */
//    public static boolean judgeSafeKeyIsLocked() {
//        boolean result = false;
//        int ret;
//        ret = XDJASafeTF.getInstance().GetPinTryCount(pinRole);
//        if (ret == JNIAPI.XKR_PASSWORD || ret == JNIAPI.XKR_KEY_LOCKED) {
//            result = true;
//        }
//        return result;
//    }
    /**
     * 判断芯片是否锁死(多芯片)
     * @return
     */
//    public static boolean judgeSafeKeyIsLocked(Context context,AppChipParam chipParam) {
//        return ChipOperate.judgeSafeKeyIsLocked(context,chipParam,Utils.pinRole);
//    }


    /**
     * 获取指定类型的chipParam
     * @param context
     * @param type
     * @return
     */
//    public static AppChipParam getChipParam(Context context, int type) {
//        List<AppChipParam> chipParams = Utils.getChipIsExistBean(context).getChipParams();
//        AppChipParam chipParam = null;
//        if (chipParams != null && chipParams.size() > 0) {
//            for (int i = 0; i < chipParams.size(); i++) {
//                if (chipParams.get(i).chipType== type) {
//                    chipParam = chipParams.get(i);
//                    break;
//                }
//            }
//        }
//        return chipParam;
//    }

    /**
     * 获取指定类型芯片的卡号
     * @param context
     * @param type
     * @return
     */
//    public static String getChipParamId(Context context, int type){
//        List<AppChipParam> chipParams = Utils.getChipIsExistBean(context).getChipParams();
//        if (chipParams != null && chipParams.size() > 0) {
//            for (int i = 0; i < chipParams.size(); i++) {
//                AppChipParam chipParam = chipParams.get(0);
//                if (chipParam.chipType == type) {
//                    return chipParam.uniqueID;
//                }
//            }
//        }
//        return null;
//    }

//    public static ChipIsExistBean getChipIsExistBean(Context context){
//        String chipParam = SharedPreferencesUtil.getChipParam(context);
//        ChipIsExistBean chipIsExistBean = GsonUtil.getInstance().jsonToObject(chipParam, new TypeToken<ChipIsExistBean>() {}.getType());
//        return chipIsExistBean;
//    }

    /**
     * 用于闪屏页或者home键回来后需要重新检测是否权限都已开启，
     * 如果没有 开启，则不显示贴膜卡界面
     * @return
     */
//    public static boolean isPermissionLacked() {
//        List<String> permissons = new ArrayList<>();
//        permissons.add(Manifest.permission.READ_SMS);
//        permissons.add(Manifest.permission.SEND_SMS);
//        permissons.add(Manifest.permission.RECEIVE_SMS);
//        permissons.add(Manifest.permission.READ_CONTACTS);
//        Map<String, Boolean> permissionState = PermissionUtil.getPermissionState(context, permissons);
//        Iterator iter = permissionState.entrySet().iterator();
//        while (iter.hasNext()) {
//            Map.Entry entry = (Map.Entry) iter.next();
//            boolean state = (boolean) entry.getValue();
//            if(!state){
//                return true;
//            }
//        }
//        return false;
//    }

    /**
     * 此方法用于跳转到芯片管家权限界面
     * @param context
     */
    public static void getAppDetailSettingIntent(Context context){
        Intent intent = new Intent();
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        if(Build.VERSION.SDK_INT >= 9){
            intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.setData(Uri.fromParts("package",context.getPackageName(),null));
        }else if(Build.VERSION.SDK_INT <= 8){
            intent.setAction(Intent.ACTION_VIEW);
            intent.setClassName("com.android.settings","com.android.settings.InstalledAppDetails");
            intent.putExtra("com.android.settings.ApplicationPkgName",context.getPackageName());
        }
        context.startActivity(intent);

    }


}



