package com.xdja.ckms.common.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.InputFilter;
import android.text.InputType;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.DigitsKeyListener;
import android.text.method.HideReturnsTransformationMethod;
import android.text.method.PasswordTransformationMethod;
import android.text.style.AbsoluteSizeSpan;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.Gravity;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.TextView;


import com.xdja.ckms.common.R;

import java.util.ArrayList;


/**
 * <p>summary:自定义的输入组合控件</p>
 * <p>description:</p>
 * <p>author:fanjiandong</p>
 * <p>time:2015/5/9 14:25</p>
 */
public class InputComponent extends LinearLayout {

    boolean isEnable = true;

    CharSequence lableText;

    ColorStateList lableColor;

    Drawable lableBkgrd;

    float lableTextSize;

    CharSequence inputText;

    ColorStateList inputColor;

    ColorStateList inputHintColor;


    Drawable inputBkgrd;

    float inputTextSize;
    float errorTextSize;
    float mHintSize;


    Drawable drawableRight;

    Drawable cursorDrawable;

    String hint;

    boolean isPassword = false;

    String digist;

    //add 2017年9月15日10:07:41 weizg editText最大的输入长度，
    int textMaxLength = -1;

    private TextView lable;

    private XEditText input;

    private CheckBox rightDrawable;

    private LinearLayout layout;

    public TextView getLable() {
        return lable;
    }

    public XEditText getInput() {
        return input;
    }

    public CheckBox getRightDrawable() {
        return rightDrawable;
    }

    Drawable mErrorIcon;
    Drawable mErrorBackgroundAbove;
    Drawable mErrorBackground;
    int mErrorTextColor;

    public boolean isEnable() {
        return isEnable;
    }

    public void setIsEnable(boolean isEnable) {
        this.isEnable = isEnable;
        this.setEnabled(isEnable);
        this.lable.setEnabled(isEnable);
        this.layout.setEnabled(isEnable);
        this.input.setEnabled(isEnable);
        this.rightDrawable.setEnabled(isEnable);

    }

    public InputComponent(Context context) {
        super(context);
    }

    public InputComponent(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(attrs);
        initView();
    }

    public InputComponent(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(attrs);
        initView();
    }


    private void init(AttributeSet attrs) {
        TypedArray a = getContext().obtainStyledAttributes(attrs, R.styleable.InputComponent);

        if (a.hasValue(R.styleable.InputComponent_lableText))
            lableText = a.getText(R.styleable.InputComponent_lableText);
        if (a.hasValue(R.styleable.InputComponent_lableTextColor))
            lableColor = a.getColorStateList(R.styleable.InputComponent_lableTextColor);
        if (a.hasValue(R.styleable.InputComponent_lableBkgrd))
            lableBkgrd = a.getDrawable(R.styleable.InputComponent_lableBkgrd);
        if (a.hasValue(R.styleable.InputComponent_lableTextSize))
            lableTextSize = a.getDimension(R.styleable.InputComponent_lableTextSize, 20);

        if (a.hasValue(R.styleable.InputComponent_inputText))
            inputText = a.getText(R.styleable.InputComponent_inputText);
        if (a.hasValue(R.styleable.InputComponent_inputTextColor))
            inputColor = a.getColorStateList(R.styleable.InputComponent_inputTextColor);
        if (a.hasValue(R.styleable.InputComponent_inputBkgrd))
            inputBkgrd = a.getDrawable(R.styleable.InputComponent_inputBkgrd);
        if (a.hasValue(R.styleable.InputComponent_inputTextSize))
            inputTextSize = a.getDimension(R.styleable.InputComponent_inputTextSize, 20);
        if (a.hasValue(R.styleable.InputComponent_inputHintColor))
            inputHintColor = a.getColorStateList(R.styleable.InputComponent_inputHintColor);
        if (a.hasValue(R.styleable.InputComponent_drawableRight))
            drawableRight = a.getDrawable(R.styleable.InputComponent_drawableRight);
        if (a.hasValue(R.styleable.InputComponent_cursorImage))
            cursorDrawable = a.getDrawable(R.styleable.InputComponent_cursorImage);
        if (a.hasValue(R.styleable.InputComponent_ErrorDefaultBackground))
            mErrorBackground = a.getDrawable(R.styleable.InputComponent_ErrorDefaultBackground);
        if (a.hasValue(R.styleable.InputComponent_ErrorDefaultBackgroundAbove))
            mErrorBackgroundAbove = a.getDrawable(R.styleable.InputComponent_ErrorDefaultBackgroundAbove);
        if (a.hasValue(R.styleable.InputComponent_ErrorTextColor))
            mErrorTextColor = a.getColor(R.styleable.InputComponent_ErrorTextColor, 0x000);
        if (a.hasValue(R.styleable.InputComponent_ErrorTextSize))
            errorTextSize = a.getDimension(R.styleable.InputComponent_ErrorTextSize, 12);
        if (a.hasValue(R.styleable.InputComponent_ErrorDefaultIcon))
            mErrorIcon = a.getDrawable(R.styleable.InputComponent_ErrorDefaultIcon);
        if (a.hasValue(R.styleable.InputComponent_mHint))
            hint = a.getString(R.styleable.InputComponent_mHint);
        if (a.hasValue(R.styleable.InputComponent_mHintTextSize))
            mHintSize = a.getDimension(R.styleable.InputComponent_mHintTextSize, 20);
        if (a.hasValue(R.styleable.InputComponent_ispassword))
            isPassword = a.getBoolean(R.styleable.InputComponent_ispassword, false);
        if (a.hasValue(R.styleable.InputComponent_digits))
            digist = a.getString(R.styleable.InputComponent_digits);
        if (a.hasValue(R.styleable.InputComponent_enable))
            isEnable = a.getBoolean(R.styleable.InputComponent_enable, true);

        if(a.hasValue(R.styleable.InputComponent_textMaxLength))//input最大长度
            textMaxLength = a.getInt(R.styleable.InputComponent_textMaxLength, -1);
    }

    @TargetApi(Build.VERSION_CODES.JELLY_BEAN)
    private void initView() {
        final float scale = getContext().getResources().getDisplayMetrics().density;

        this.setOrientation(HORIZONTAL);
        this.setGravity(Gravity.CENTER_VERTICAL);

        lable = new TextView(getContext());
        if (this.lableText != null) {
            lable.setText(this.lableText);
        }
        if (lableColor != null) {
            lable.setTextColor(this.lableColor);
        }
        if (lableTextSize > 0) {
            lable.setTextSize(TypedValue.COMPLEX_UNIT_PX, lableTextSize);
        }
        if (lableBkgrd != null) {
            lable.setBackground(this.lableBkgrd);
        }
        lable.setGravity(Gravity.LEFT| Gravity.CENTER_VERTICAL);
        lable.setPadding(0, 0, 0, 0);


        //int lableWidth = (int) (98 * scale + 0.5f);
        //LayoutParams lllable = new LayoutParams(lableWidth, LayoutParams.WRAP_CONTENT);
        LayoutParams lllable = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        lllable.gravity = Gravity.CENTER;
        this.addView(lable, lllable);

        int layoutPadding = (int) (10 * scale + 0.5f);
        layout = new LinearLayout(getContext());
        layout.setPadding( layoutPadding, 0, 0, 0);
        layout.setOrientation(HORIZONTAL);
        layout.setGravity(Gravity.CENTER_VERTICAL);
        layout.setLayoutParams(new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT));
        if (this.inputBkgrd != null) {
            layout.setBackground(this.inputBkgrd);
        }


        input = new XEditText(getContext());


        input.setPadding(0, 0, (int) (6 * scale + 0.5f), 0);
        input.setSingleLine(true);
        input.setBackgroundColor(0x00000000);
        input.setGravity(Gravity.CENTER_VERTICAL);
        if (this.inputText != null) {
            input.setText(this.inputText);
        }
        if (this.inputColor != null) {
            input.setTextColor(this.inputColor);
        }
        if (this.inputTextSize > 0) {
            input.setTextSize(TypedValue.COMPLEX_UNIT_PX, this.inputTextSize);
        }
        if (this.inputHintColor != null) {
            input.setHintTextColor(this.inputHintColor);
        }

        if (this.cursorDrawable != null){
            input.setCursorVisible(true);
        }
        if (mErrorBackground != null) {
            input.setmErrorBackground(mErrorBackground);
        }
        if (mErrorBackgroundAbove != null) {
            input.setmErrorBackgroundAbove(mErrorBackgroundAbove);
        }
        if (mErrorIcon != null) {
            input.setmErrorIcon(mErrorIcon);
        }
        if (mErrorTextColor < 0) {
            input.setmErrorTextColor(mErrorTextColor);
        }
        if (!TextUtils.isEmpty(hint)){
            SpannableString ss = new SpannableString(hint);
            AbsoluteSizeSpan ass = new AbsoluteSizeSpan((int) mHintSize);
            ss.setSpan(ass, 0 ,ss.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            input.setHint(new SpannableString(ss));
        }

//        if (isPassword) {
//            input.setInputType(InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_VARIATION_PASSWORD);
//        } else {
//            input.setInputType(InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_VARIATION_VISIBLE_PASSWORD);
//        }
        if (!isPassword) {
            // 显示密码
            input.setTransformationMethod(HideReturnsTransformationMethod.getInstance());
        } else {
            // 隐藏密码
            input.setTransformationMethod(PasswordTransformationMethod.getInstance());
        }
        if (!TextUtils.isEmpty(digist) || textMaxLength != -1) {
            /*NumberKeyListener numberKeyListener = new NumberKeyListener() {
                @Override
                protected char[] getAcceptedChars() {
                    return digist.toCharArray();
                }

                @Override
                public int getInputType() {
                    return input.getInputType();
                }
            };*/
            //input.setKeyListener(numberKeyListener);

            //del 2017年2月16日16:38:52 weizg
            // 如果选择Android默认输入法，下面的方法会导致输入法只显示数字，无法切换到字母输入
//            input.setKeyListener(DigitsKeyListener.getInstance(digist));

//            InputFilter[] filters = {DigitsKeyListener.getInstance(digist)};

            ArrayList<InputFilter> inputFilters = new ArrayList<>();
            if(!TextUtils.isEmpty(digist)){
                inputFilters.add(DigitsKeyListener.getInstance(digist));
            }

            if(textMaxLength != -1){
                inputFilters.add(new InputFilter.LengthFilter(textMaxLength));
            }

            if(inputFilters.size() > 0){
                InputFilter[] filters = inputFilters.toArray(new InputFilter[inputFilters.size()]);
                input.setFilters(filters);
            }
            input.setInputType(InputType.TYPE_TEXT_VARIATION_PASSWORD);

        }

        LayoutParams llinput = new LayoutParams(0, LayoutParams.MATCH_PARENT);
        llinput.weight = 1;
        llinput.gravity = Gravity.CENTER_VERTICAL;
        layout.addView(input, llinput);

        rightDrawable = new CheckBox(getContext());
        rightDrawable.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                int cursorIndex = input.getSelectionStart();
                if (isChecked) {
                    // 显示密码
                    input.setTransformationMethod(HideReturnsTransformationMethod.getInstance());
                } else {
                    // 隐藏密码
                    input.setTransformationMethod(PasswordTransformationMethod.getInstance());
                }
                input.setSelection(cursorIndex);
            }
        });
        rightDrawable.setButtonDrawable(new ColorDrawable(Color.TRANSPARENT));
        if (rightDrawable != null && isPassword) {
            rightDrawable.setBackground(drawableRight);
            LayoutParams llright = new LayoutParams((int)(16*scale), (int)(16*scale));
            llright.gravity = Gravity.CENTER_VERTICAL;
            layout.addView(rightDrawable, llright);
        }
        this.addView(layout);
        setIsEnable(isEnable);
    }
}
