package com.xdja.permission;

import android.support.annotation.NonNull;

import java.util.List;

/**
 * Created by xwy on 2017/10/13.
 */

public class PermissionBean {
    private List<String> permissionsNative = null;
    private int requestCode = -1;

    @SuppressWarnings("null")
    public PermissionBean(List<String> permissions, int requestCode) {
        if (permissions == null && permissions.size() <= 0) {
            throw new IllegalArgumentException("Permissions must be not null!");
        }
        permissionsNative = permissions;
        this.requestCode = requestCode;
    }

    public List<String> getPermissions() {
        return permissionsNative;
    }

    public int getRequestCode() {
        return requestCode;
    }

    public void setPermissions(@NonNull List<String> permissions) {
        this.permissionsNative = permissions;
    }
}
