package com.xdja.scservice.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.ckms.common.R;

/**
 * Created by xwy on 2016/8/12.
 */
public class ToastCommon extends Toast{
    private static Toast toast;

    public ToastCommon(Context context){
        super(context);
    }

    public static void makeText(Context context, CharSequence text) {
        View view = LayoutInflater.from(context).inflate(R.layout.toast, null);
        TextView tv = (TextView) view.findViewById(R.id.toast_text);

        final float scale = context.getResources().getDisplayMetrics().density;

        Toast toast = getToast(context);
        tv.setText(text);
        //toast.setText(text);
        toast.setDuration(Toast.LENGTH_SHORT);
        toast.setView(view);
        toast.setGravity(Gravity.BOTTOM, 0, (int) (68 * scale + 0.5f));
        toast.show();
        //return toast;
    }
    public static void makeText(Context context, @NonNull String string) {
        View view = LayoutInflater.from(context).inflate(R.layout.toast, null);
        TextView tv = (TextView) view.findViewById(R.id.toast_text);

        final float scale = context.getResources().getDisplayMetrics().density;

        Toast toast = getToast(context);
        tv.setText(string);
        //toast.setText(text);
        toast.setDuration(Toast.LENGTH_SHORT);
        toast.setView(view);
        toast.setGravity(Gravity.BOTTOM, 0, (int) (68 * scale + 0.5f));
        toast.show();
        //return toast;
    }

    public static void makeText(Context context, @StringRes  int string) {
        View view = LayoutInflater.from(context).inflate(R.layout.toast, null);
        TextView tv = (TextView) view.findViewById(R.id.toast_text);

        final float scale = context.getResources().getDisplayMetrics().density;

        Toast toast = getToast(context);
        tv.setText(string);
        //toast.setText(text);
        toast.setDuration(Toast.LENGTH_SHORT);
        toast.setView(view);
        toast.setGravity(Gravity.BOTTOM, 0, (int) (68 * scale + 0.5f));
        toast.show();
        //return toast;
    }

    public static void makeTextInCenter(Context context, @StringRes  int string) {
        View view = LayoutInflater.from(context).inflate(R.layout.toast, null);
        TextView tv = (TextView) view.findViewById(R.id.toast_text);

        final float scale = context.getResources().getDisplayMetrics().density;

        Toast toast = getToast(context);
        tv.setText(string);
        //toast.setText(text);
        toast.setDuration(Toast.LENGTH_SHORT);
        toast.setView(view);
        toast.setGravity(Gravity.CENTER, 0, (int) (68 * scale + 0.5f));
        toast.show();
        //return toast;
    }

    private static Toast getToast(Context context){
        if (toast == null){
            toast = new Toast(context);
        }
        return toast;
    }

}
