package com.xdja.safekeyservice.forlog;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Process;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;

import com.xdja.safekeyservice.forlog.utils.LogcatUtils;

/**
 * @author: zhangxiaolong@xdja.com <br/>
 * date:   2018/5/7 <br/>
 */
public class ForLogProvider extends ContentProvider {

    private static Context context;

    public static Context getStaticContext() {
        return context;
    }

    @Override
    public boolean onCreate() {
        context = getContext();
        return false;
    }

    @Override
    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }

    @Override
    public String getType(Uri uri) {
        return null;
    }

    @Override
    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    @Override
    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    @Override
    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }

    public static final String KEY_ret = "ret";
    public static final String KEY_isOnceLogging = "isOnceLogging";
    public static final String KEY_flagOnceLog = "flagOnceLog";
    public static final String KEY_startOnceLog = "startOnceLog";
    public static final String KEY_stopOnceLog = "stopOnceLog";
    public static final String KEY_getLogFilePath = "getLogFilePath";
    public static final String KEY_logFilePath = "logFilePath";
    public static final String KEY_autoDelLogFile = "autoDelLogFile";
    public static final String KEY_zipNeedUploadLogFiles = "zipNeedUploadLogFiles";

    @Override
    public Bundle call(String method, String arg, Bundle extras) {
        if (TextUtils.isEmpty(method)) {
            return super.call(method, arg, extras);
        }

        if (method.equals(KEY_isOnceLogging)) {
            return getIsOnceLogging();
        } else if (method.equals(KEY_startOnceLog)) {
            return startOnceLog();
        } else if (method.equals(KEY_stopOnceLog)) {
            return stopOnceLog();
        } else if (method.equals(KEY_getLogFilePath)) {
            return getLogFilePath();
        } else if (method.equals(KEY_autoDelLogFile)) {
            return autoDelLogFile();
        } else if (method.equals(KEY_zipNeedUploadLogFiles)) {
            return zipNeedUploadLogFiles();
        } else {
            Bundle bundle = new Bundle();
            bundle.putInt(KEY_ret, -1);
            return bundle;
        }
    }

    private boolean flagOnceLog = false;

    /**
     * 得到是否正在打印一次性日志
     *
     * @return
     */
    private Bundle getIsOnceLogging() {
        Bundle bundle = new Bundle();
        bundle.putInt(KEY_ret, 0);
        bundle.putBoolean(KEY_flagOnceLog, flagOnceLog);
        return bundle;
    }

    private Bundle startOnceLog() {
        Bundle bundle = new Bundle();
        if (flagOnceLog) {
            bundle.putInt(KEY_ret, 1);
        } else {
            flagOnceLog = true;
            bundle.putInt(KEY_ret, 0);
            Intent intent = new Intent();
            intent.setClass(getContext(), ForLogService.class);
            intent.putExtra(ForLogService.KEY_method, ForLogService.KEY_startOnceLog);
            getContext().startService(intent);
        }

        Log.d("forLog", "startOnceLog: " + flagOnceLog);

        return bundle;
    }

    private Bundle stopOnceLog() {
        Bundle bundle = new Bundle();
        bundle.putInt(KEY_ret, 0);
        Intent intent = new Intent();
        intent.setClass(getContext(), ForLogService.class);
        getContext().stopService(intent);
//        Process.killProcess(Process.myPid());

        flagOnceLog = false;

        //如果不用线程执行 killProcess，则当killProcess执行时，
        // 也会把与provider连接的芯片管家主进程一起kill
        new Thread(new Runnable() {
            @Override
            public void run() {
                SystemClock.sleep(200);
                Process.killProcess(Process.myPid());
            }
        }).start();

        return bundle;
    }

    private Bundle getLogFilePath() {
        Bundle bundle = new Bundle();
        bundle.putInt(KEY_ret, 0);
        //logFilePath
        bundle.putString(KEY_logFilePath, LogcatUtils.getLogFileDirectory());
        return bundle;
    }

    private Bundle autoDelLogFile() {
        Bundle bundle = new Bundle();
        bundle.putInt(KEY_ret, 0);

        Intent intent = new Intent();
        intent.setClass(getContext(), ForLogJobScheduleService.class);
        intent.putExtra(ForLogJobScheduleService.KEY_method, ForLogJobScheduleService.KEY_autoDelLogFile);
        getContext().startService(intent);

        return bundle;
    }

    private Bundle zipNeedUploadLogFiles() {
        Bundle bundle = new Bundle();
        Pair<Integer, String> pair = LogcatUtils.zipNeedUploadLogFiles();
        bundle.putInt(KEY_ret, pair.first);
        if (pair.first == 0) {
            bundle.putString(KEY_zipNeedUploadLogFiles, pair.second);
        }
        return bundle;
    }
}
