package com.xdja.safekeyservice.forlog.jar;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.util.Pair;

import com.xdja.safekeyservice.forlog.ForLogProvider;

import static com.xdja.safekeyservice.forlog.ForLogProvider.KEY_ret;
import static com.xdja.safekeyservice.forlog.ForLogProvider.KEY_zipNeedUploadLogFiles;

/**
 * @author: zhangxiaolong@xdja.com <br/>
 * date:   2018/5/7 <br/>
 */
public class JarForLog {
    private static JarForLog instance;

    private JarForLog() {

    }

    public static JarForLog getInstance() {
        if (instance == null) {
            synchronized (JarForLog.class) {
                if (instance == null) {
                    instance = new JarForLog();
                }
            }
        }
        return instance;
    }

    /**
     * 得到是否正在打印日志
     *
     * @param context
     * @return 1:正在；-1：没有
     */
    public int getIsOnceLogging(Context context) {
        ContentResolver resolver = context.getContentResolver();
        Bundle bundle = resolver.call(getUri(context), ForLogProvider.KEY_isOnceLogging, "", null);

        if (bundle != null) {
            boolean flag = bundle.getBoolean(ForLogProvider.KEY_flagOnceLog);

            Log.d("forLog", "bundle-flag: " + flag);
            if (flag) {
                return 1;
            }
        }
        return -1;
    }

    /**
     * 开始打印日志
     *
     * @param context
     * @return
     */
    public int startOnceLog(Context context) {
        ContentResolver resolver = context.getContentResolver();
        resolver.call(getUri(context), ForLogProvider.KEY_startOnceLog, "", null);
        return 0;
    }

    /**
     * 停止打印日志
     *
     * @param context
     * @return
     */
    public int stopOnceLog(Context context) {
        ContentResolver resolver = context.getContentResolver();
        resolver.call(getUri(context), ForLogProvider.KEY_stopOnceLog, "", null);
        return 0;
    }

    public String getLogFilePath(Context context) {
        ContentResolver resolver = context.getContentResolver();
        Bundle bundle = resolver.call(getUri(context), ForLogProvider.KEY_getLogFilePath, "", null);
        if (bundle == null) {
            return "";
        }
        if (bundle.containsKey(KEY_ret) && bundle.containsKey(ForLogProvider.KEY_logFilePath)) {
            return bundle.getString(ForLogProvider.KEY_logFilePath);
        }
        return "";
    }

    /**
     * 根据自定义策略自动删除日志文件
     *
     * @param context context
     * @return ret
     */
    public int autoDelLogFile(Context context) {
        ContentResolver resolver = context.getContentResolver();
        resolver.call(getUri(context), ForLogProvider.KEY_autoDelLogFile, "", null);
        return 0;
    }

    public Pair<Integer, String> zipNeedUploadLogFiles(Context context) {
        ContentResolver resolver = context.getContentResolver();
        Bundle bundle = resolver.call(getUri(context), ForLogProvider.KEY_zipNeedUploadLogFiles, "", null);
        if (bundle == null) {
            return Pair.create(-1, "");
        }
        int ret = bundle.getInt(KEY_ret, -1);
        String path = "";
        if (ret == 0) {
            path = bundle.getString(KEY_zipNeedUploadLogFiles);
        }
        return Pair.create(ret, path);
    }

    private Uri getUri(Context context) {
        return Uri.parse("content://" + context.getPackageName() + ".forlog.ForLogProvider");
    }

}
