package com.xdja.safekeyservice.forlog.report;

import android.content.Context;
import android.util.Log;

import com.google.gson.Gson;
import com.xdja.safekeyservice.forlog.report.bean.FileResult;
import com.xdja.safekeyservice.forlog.report.bean.ReportBean;
import com.xdja.safekeyservice.forlog.report.bean.ReportEntity;
import com.xdja.safekeyservice.forlog.report.bean.ReportMessage;
import com.xdja.safekeyservice.forlog.report.bean.ReportResult;
import com.xdja.safekeyservice.forlog.report.callback.ReportMsgCallback;
import com.xdja.safekeyservice.forlog.report.netApi.HttpInterface;
import com.xdja.safekeyservice.forlog.report.util.ConfigurationServer;
import com.xdja.safekeyservice.forlog.report.util.RetrofitManager;
import com.xdja.safekeyservice.forlog.report.util.SignUtil;
import com.xdja.safekeyservice.forlog.report.util.UploadLogUtil;

import java.io.File;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Response;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

/**
 * Created by jyg on 2019/5/24
 */
public class ReportMessageManager {
    private static final String CLASS_NAME = ReportMessageManager.class.getName();

    private static final long EXP_TIME = 7 * 24 * 60 * 60 * 1000;
    private static final String TYPE = "100";
    private static final String SUB_TYPE = "10004";
    private static final String REPORT_VERSION = "2.0";

    /**
     * @param paths         上传文件路径
     * @param reportMessage 反馈问题
     * @param callback      回调back
     * @param context
     */

    public static void uploadReportFile(final List<String> paths, final ReportMessage reportMessage,
                                        final ReportMsgCallback callback, final Context context) {

/*        Observable.just("")
                .map(new Func1<String, Integer>() {
                    @Override
                    public Integer call(String s) {
                        //dd zip
               *//* String zipLogFilePath = "";
                try {
                    zipLogFilePath = UploadLogUtil.zipLocalLog();
                } catch (IOException e) {
                    e.printStackTrace();

                    return -1;
                }
                paths.add(zipLogFilePath);*//*

                        //dd2 upload
                        uploadReportFileAndMessage(reportMessage, paths, callback, context);

                        return 0;
                    }
                })
                */
              Observable.just("").flatMap(new Func1<String, Observable<Integer>>() {
                  @Override
                  public Observable<Integer> call(String s) {
                      try {
                          uploadReportFileAndMessage(reportMessage, paths, callback, context);
                      } catch (IOException e) {
                          e.printStackTrace();

                          Log.i(CLASS_NAME, "uploadReportFile exception......");

                          return Observable.just(-1);
                      }

                      return Observable.just(0);
                  }
              })
                .subscribeOn(Schedulers.io())
                .observeOn(Schedulers.io())
                .subscribe(new Subscriber<Integer>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        e.printStackTrace();
                        callback.onFail();
                    }

                    @Override
                    public void onNext(Integer integer) {
                        // TODO: 2019/9/26
                        if(integer == 0){
                            callback.onSuccess();
                        }else {
                            callback.onFail();
                        }
                    }
                });


    }

    private static void uploadReportFileAndMessage(final ReportMessage reportMessage,
                                                   final List<String> paths,
                                                   final ReportMsgCallback callback,
                                                   final Context context) throws IOException {
        //step1 首先把文件上传到fastdfs
        //step2 然后上传report服务

        reportMessage.setAppId(getAppId(context));

        //fastdfs的参数
        final String ts = String.valueOf(System.currentTimeMillis() + EXP_TIME);
        String fastDfs = RetrofitManager.getBaseUrl(context, RetrofitManager.FASTDFS_URL_TAG);
        String sign = null;
        final String userId = RetrofitManager.getUserId(context, fastDfs);
        final String userSecret = RetrofitManager.getUsersecret(context, fastDfs);

        try {
            sign = SignUtil.hamcsha1ReportFile(userId + ts, userSecret);
        } catch (NoSuchAlgorithmException | InvalidKeyException e) {
            e.printStackTrace();
        }

        Log.i(CLASS_NAME, "n here .....");

        //step1 循环上传文件
        //fastdfs接口
        //2019年11月1日11:34:09 weig 修改为https通道
        final HttpInterface httpInterface = RetrofitManager. getRetrofitFastDfs_https (fastDfs, context);

        final List<FileResult> fileResults = new ArrayList<>();
        final String finalSign = sign;

        for (int i = 0; i < paths.size(); i++) {
            List<String> filePath = new ArrayList<>();
            filePath.add(paths.get(i));

            //网络交互，上传文件
            /*List<FileResult> fileResults1 = httpInterface.uploadReportFileSync(getMultipartBody(filePath), userId, ts, finalSign);
            if(fileResults1 != null){
                fileResults.addAll(fileResults1);
            }*/

            Response<List<FileResult>> listResponse =
                    httpInterface.uploadReportFileSync(getMultipartBody(filePath), userId, ts, finalSign).execute();

            if (!listResponse.isSuccessful()) {
                Log.d(CLASS_NAME, "Upload file fail: " + listResponse.code());
                return;
            }

            List<FileResult> bodyFile = listResponse.body();
            if (bodyFile != null && bodyFile.size() > 0) {
                fileResults.addAll(listResponse.body());
            }
        }


        //step2 下一步向report服务上传记录
        //如果还有文件未上传，则继续向fastdfs上传文件
        if (fileResults.size() != paths.size()) {
            //如果未全部上传成功，依然向report服务提交记录
            Log.i(CLASS_NAME, "not Upload all file......");
//            return;
        }

        Log.i(CLASS_NAME, "Upload file complete, now report server");
        HttpInterface httpInterface_report = RetrofitManager.
                getRetrofitReport(RetrofitManager.getBaseUrl(context, RetrofitManager.REPORT_URL_TAG), context);

        //上报report结果
        Response<ReportResult> reportResultResponse =
                httpInterface_report.reportErrorMsgSync(getReportEntity(context, reportMessage, fileResults)).execute();

        if(!reportResultResponse.isSuccessful()){
            Log.d(CLASS_NAME, "reportResultResponse code: " + reportResultResponse.code());
            return;
        }

        if (reportResultResponse.body() != null) {
            Log.i(CLASS_NAME, "reportResult.ret: " + reportResultResponse.body().getRes());
        }
    }

    private static ReportEntity getReportEntity(Context context, ReportMessage reportMessage, List<FileResult> fileResults) {
        String appid = getAppId(context);
        String key = getKey(context);
        Log.d(CLASS_NAME, "AppId:" + appid);

        List<String> attachments = new ArrayList<>();
        for (FileResult fileResult : fileResults) {
            attachments.add(fileResult.getFileid());
        }
        reportMessage.setAttachments(attachments);
        ReportBean bean = new ReportBean();
        bean.setSubtype(SUB_TYPE);
        bean.setType(TYPE);
        bean.setVersion(REPORT_VERSION);
        bean.setMessage(reportMessage);

        Gson gson = new Gson();
        String json = gson.toJson(bean);
//        String signJson = SignUtil.hamcsha1SignReport(json, HttpInterface.key);
        String signJson = SignUtil.hamcsha1SignReport(json, key);

        ReportEntity reportEntity = new ReportEntity();
        reportEntity.setMsg(json);
//        reportEntity.setAppId(HttpInterface.appId);
        reportEntity.setAppId(appid);
        reportEntity.setSignature(signJson);
        return reportEntity;
    }

    private static List<MultipartBody.Part> getMultipartBody(List<String> pathes) {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (int i = 0; i < pathes.size(); i++) {
            File uploadFile = new File(pathes.get(i));
            if (uploadFile.exists()) {
                RequestBody body = RequestBody.create(MediaType.parse("multipart/form-data"), uploadFile);
                builder.addFormDataPart("file" + i, uploadFile.getName(), body);
            }
        }
        return builder.build().parts();
    }

    private static String getAppId(Context context) {
        ConfigurationServer server = ConfigurationServer.getAssetsConfig(context.getApplicationContext());
        if (server != null) {
            return server.read("appId", "", String.class);
        }
        return null;
    }

    private static String getKey(Context context) {
        ConfigurationServer server = ConfigurationServer.getAssetsConfig(context.getApplicationContext());
        if (server != null) {
            return server.read("appKey", "", String.class);
        }
        return null;
    }
}
