package com.xdja.safekeyservice.forlog.report.util;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;


import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * 读取配置文件的类
 */
public class ConfigurationServer {
    private static final String CLASS_NAME = ConfigurationServer.class.getName();
    private static final String assetsConfigName = "report_config.properties";

    private static ConfigurationServer assetsConfig;

    /**
     * 获取Assets目录中default.properties文件的配置
     *
     * @param context 上下文句柄
     * @return 目标对象
     */
    public static ConfigurationServer getAssetsConfig(Context context) {
        try {
            InputStream is = context.getAssets().open(assetsConfigName);
            assetsConfig = new ConfigurationServer(is);
        } catch (IOException e) {
            Log.i(CLASS_NAME, e.getMessage());
            return null;
        }
        return assetsConfig;
    }

    public static ConfigurationServer getAssetsConfig(Context context, String assetsConfigName) {
        try {
            InputStream is = context.getAssets().open(assetsConfigName);
            assetsConfig = new ConfigurationServer(is);
        } catch (IOException e) {
            Log.i(CLASS_NAME, e.getMessage());
            return null;
        }
        return assetsConfig;
    }


    private Properties properties;

    private ConfigurationServer(InputStream inputStream) {
        try {
            properties = new Properties();
            properties.load(inputStream);
        } catch (IOException ex) {
            Log.e(CLASS_NAME, ex.getMessage());
        }
    }

    /**
     * 读取配置信息
     *
     * @param configName   配置名称
     * @param defaultValue 默认值
     * @param cls          值类型
     * @param <T>
     * @return 读取到的配置
     */
    public <T> T read(String configName, T defaultValue, Class<T> cls) {
        if (TextUtils.isEmpty(configName)) {
            return defaultValue;
        }
        try {
            String value = properties.getProperty(configName);
            if (cls == String.class)
                return cls.cast(value);
            else if (cls == Integer.class)
                return cls.cast(Integer.valueOf(value));
            else if (cls == Boolean.class)
                return cls.cast(Boolean.valueOf(value));
            else if (cls == Long.class)
                return cls.cast(Long.valueOf(value));
            else
                return defaultValue;
        } catch (ClassCastException ex) {
            Log.e(CLASS_NAME, ex.getMessage());
            return defaultValue;
        }
    }

}
