package com.xdja.safekeyservice.forlog.report.util;

import android.content.Context;

import com.xdja.safekeyservice.forlog.BuildConfig;
import com.xdja.safekeyservice.forlog.R;
import com.xdja.safekeyservice.forlog.report.netApi.HttpInterface;
import com.xdja.safekeyservice.forlog.utils.FucUitls;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.concurrent.TimeUnit;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

import static android.content.ContentValues.TAG;

/**
 * Created by jyg on 2019/5/28
 */
public class RetrofitManager {
    /**
     * 默认的超时时间
     */
    private static final int CONN_TIME_OUT_UNIT = 2 * 15 * 1000;
    private static final int READ_TIME_OUT_UNIT = 2 * 15 * 1000;
    private static final int WRITE_TIME_OUT_UNIT = 2 * 15 * 1000;
//    private static final String DEFAULT_PASSWORD = "111111";
//            rsa2048 密码
    private static final String DEFAULT_PASSWORD = FucUitls.getDefaultBksmm();

    public static final String FASTDFS_URL_TAG = "fastDfsUrl";
    public static final String REPORT_URL_TAG = "reportUrl";

//    String key = "30ea4a8f887f4138941bb754b0737d91";
//    String appId = "ATDialer";
//
//
    static String userid = "3298fskmnfl282hn9fh23f";
    static String usersecret = "90vjfo29s7cn25lal239f";

    //fastDfs
    //准生产
    static String usersecretTest = "4167e9fa06468f65";
    static String useridTest = "1ab7dea9eaf1e820";
    //生产
    static String usersecretPyis = "315fd2c1b79e1d39";
    static String useridPyis = "0f5fb4ebe388926c";

    public static HttpInterface getRetrofitReport(String baseUrl, Context context) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder()
                .sslSocketFactory(makeSSLSocketFactory(context))
                .hostnameVerifier(getHostnameVerifier())
                .readTimeout(CONN_TIME_OUT_UNIT, TimeUnit.MILLISECONDS)
                .writeTimeout(READ_TIME_OUT_UNIT, TimeUnit.MILLISECONDS)
                .connectTimeout(WRITE_TIME_OUT_UNIT, TimeUnit.MILLISECONDS)
                .addInterceptor(getLoggingInterceptor())
                .build();
        return new Retrofit.Builder()
                .baseUrl(baseUrl)
                .addConverterFactory(GsonConverterFactory.create())
//                .addCallAdapterFactory(RxJavaCallAdapterFactory.create())
                .client(okHttpClient)
                .build()
                .create(HttpInterface.class);
    }

    public static HttpInterface getRetrofitFastDfs(String baseUrl) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder()
                .readTimeout(CONN_TIME_OUT_UNIT, TimeUnit.MILLISECONDS)
                .writeTimeout(READ_TIME_OUT_UNIT, TimeUnit.MILLISECONDS)
                .connectTimeout(WRITE_TIME_OUT_UNIT, TimeUnit.MILLISECONDS)
                .addInterceptor(getLoggingInterceptor())
                .build();
        return new Retrofit.Builder()
                .baseUrl(baseUrl)
                .addConverterFactory(GsonConverterFactory.create())
//                .addCallAdapterFactory(RxJavaCallAdapterFactory.create())
                .client(okHttpClient)
                .build()
                .create(HttpInterface.class);
    }

    //fastdfs-https
    public static HttpInterface getRetrofitFastDfs_https(String baseUrl, Context context) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder()
                .sslSocketFactory(makeSSLSocketFactory(context))
                .hostnameVerifier(getHostnameVerifier())
                .readTimeout(CONN_TIME_OUT_UNIT, TimeUnit.MILLISECONDS)
                .writeTimeout(READ_TIME_OUT_UNIT, TimeUnit.MILLISECONDS)
                .connectTimeout(WRITE_TIME_OUT_UNIT, TimeUnit.MILLISECONDS)
                .addInterceptor(getLoggingInterceptor())
                .build();
        return new Retrofit.Builder()
                .baseUrl(baseUrl)
                .addConverterFactory(GsonConverterFactory.create())
//                .addCallAdapterFactory(RxJavaCallAdapterFactory.create())
                .client(okHttpClient)
                .build()
                .create(HttpInterface.class);
    }

    private static HttpLoggingInterceptor getLoggingInterceptor(){
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
        if (BuildConfig.DEBUG) {
            httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        }else {
            httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
        }

        return httpLoggingInterceptor;
    }

    /**
     * 获取SSLSocketFactory
     *
     * @return
     */
    private static SSLSocketFactory makeSSLSocketFactory(Context context) {
        SSLContext sslContext = getSSLContext(
                readKeyStore(context, R.raw.report_truststore));
        if (sslContext == null) {
            return null;
        }
        return sslContext.getSocketFactory();
    }

    /**
     * 读取本地证书
     *
     * @param res 证书资源ID
     * @return 获取到的证书
     */
    private static KeyStore readKeyStore(Context context, int res) {
        InputStream inputStream = null;
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            inputStream = context.getResources().openRawResource(res);
            keyStore.load(inputStream, DEFAULT_PASSWORD.toCharArray());
        } catch (KeyStoreException | CertificateException | IOException | NoSuchAlgorithmException kse) {
            android.util.Log.e(TAG, kse.getMessage());
        } finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException ignored) {
                }
            }
            return keyStore;
        }
    }

    /**
     * 获取SSL连接上下文
     *
     * @param keyStore
     * @return
     */
    private static SSLContext getSSLContext(KeyStore keyStore) {
        if (keyStore == null) {
            return null;
        }
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");

            TrustManagerFactory trustManagerFactory =
                    TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);

            KeyManagerFactory keyManagerFactory =
                    KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, DEFAULT_PASSWORD.toCharArray());

            sslContext.init(
                    keyManagerFactory.getKeyManagers(),
                    trustManagerFactory.getTrustManagers(),
                    new SecureRandom()
            );
        } catch (NoSuchAlgorithmException | KeyStoreException | UnrecoverableKeyException | KeyManagementException ne) {
        }
        return sslContext;
    }

    //获取HostnameVerifier
    private static HostnameVerifier getHostnameVerifier() {
        HostnameVerifier hostnameVerifier = new HostnameVerifier() {
            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        };
        return hostnameVerifier;
    }

    public static String getBaseUrl(Context context, String urlTag) {
        ConfigurationServer server = ConfigurationServer.getAssetsConfig(context.getApplicationContext());
        if (server != null) {
            return server.read(urlTag, "", String.class);
        }
        return null;
    }

    public static String getUserId(Context context, String pro) {
//        ConfigurationServer server = ConfigurationServer.getAssetsConfig(context.getApplicationContext());
//        if (server != null) {
//            return server.read("userid", "", String.class);
//        }
//        return null;
        return pro.contains("test") ? useridTest : useridPyis;
    }

    public static String getUsersecret(Context context,String pro) {
//        ConfigurationServer server = ConfigurationServer.getAssetsConfig(context.getApplicationContext());
//        if (server != null) {
//            return server.read("usersecret", "", String.class);
//        }
//        return null;
        return pro.contains("test") ? usersecretTest : usersecretPyis;
    }
}
