package com.xdja.safekeyservice.forlog.report.util;

import com.xdja.safekeyservice.forlog.utils.LogcatUtils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * 项目名称：  Actoma+V2          <br>
 * 类描述  ： 日志上报        <br>
 * 创建时间：2017/6/2     <br>
 * 修改记录：             <br>
 *
 * @author jyg@xdja.com   <br>
 */


public class UploadLogUtil {

    // TODO: 2019/9/26 日志文件夹
    public static final String LOG_ZIP_NAME = "chipManager";
    public static final String XLOG_ZIP_NAME = "chipManager_xlog";
    public static final String LOG_PATH = LogcatUtils.getLogFileDirectory();

    private static final long DAY_TIME = 3 * 3600 * 24 * 1000;

    public static String zipLocalLog() throws IOException {

        File fileDir = new File(LOG_PATH);
        List<String> filePaths = new ArrayList<>();
        long currentTime = System.currentTimeMillis();
        if (fileDir.isDirectory()) {
            File[] files = fileDir.listFiles();
            for (File f : files) {
                long lastModifiedTime = f.lastModified();
                if (f.isFile() && f.getName().contains(".log") && (currentTime - lastModifiedTime < DAY_TIME)) {
                    filePaths.add(f.getAbsolutePath());
                }
            }
        }

        String logPath = fileDir.getAbsolutePath() +
                "/" + LOG_ZIP_NAME;

        File file = new File(logPath);
        if (file.exists()) {
            file.delete();
        }

        boolean isZip = ZipUtilRaw.zipCompress(filePaths, logPath);
        if (!isZip) {
            //压缩日志失败
            return "";
        }
        return logPath;
    }

    public static String zipXlogFile() {
        File fileDir = new File(LogcatUtils.getXlogFileDirectory());
        List<String> filePaths = new ArrayList<>();
        long currentTime = System.currentTimeMillis();
        if (fileDir.isDirectory()) {
            File[] files = fileDir.listFiles();
            for (File f : files) {
                long lastModifiedTime = f.lastModified();
                if (f.isFile() && f.getName().contains(".xlog") && (currentTime - lastModifiedTime < DAY_TIME)) {
                    filePaths.add(f.getAbsolutePath());
                }
            }
        }

        String logPath = fileDir.getAbsolutePath() +
                "/" + XLOG_ZIP_NAME;

        File file = new File(logPath);
        if (file.exists()) {
            file.delete();
        }

        boolean isZip = ZipUtilRaw.zipCompress(filePaths, logPath);
        if (!isZip) {
            //压缩日志失败
            return "";
        }
        return logPath;
    }
}
