package com.xdja.safekeyservice.forlog.report.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/**
 * 项目名称：            <br>
 * 类描述  ：           <br>
 * 创建时间：2017/6/6     <br>
 * 修改记录：             <br>
 *
 * @author jyg@xdja.com   <br>
 */


public class ZipUtilRaw {

    /**@param srcFiles 需压缩的文件路径及文件名
     * @param desFile 保存的文件名及路径
     * @return  如果压缩成功返回true
     */
    public static boolean zipCompress(List<String> srcFiles, String desFile) {
        boolean isSuccessful = false;

        String[] fileNames = new String[srcFiles.size()];
        for (int i = 0; i < srcFiles.size(); i++) {
            fileNames[i] = parse(srcFiles.get(i));
        }

        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(desFile));
            ZipOutputStream zos = new ZipOutputStream(bos);

            for (int i = 0; i < fileNames.length; i++) {
                String entryName = fileNames[i];

                // 创建Zip条目
                ZipEntry entry = new ZipEntry(entryName);
                zos.putNextEntry(entry);

                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(srcFiles.get(i)));

                byte[] b = new byte[1024];

                while (bis.read(b, 0, b.length) != -1) {
                    zos.write(b, 0, b.length);
                    if (bis.available()<1024 && bis.available()>0) {
                        b = new byte[bis.available()];
                    }
                }
                bis.close();
                zos.closeEntry();
            }

            zos.flush();
            zos.close();
            isSuccessful = true;
        } catch (IOException e) {
        }

        return isSuccessful;
    }

    // 解析文件名
    private static String parse(String srcFile) {
        int location = srcFile.lastIndexOf("/");
        String fileName = srcFile.substring(location + 1);
        return fileName;
    }
}
