package com.xdja.safekeyservice.forlog.utils;

import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;

import com.xdja.safekeyservice.forlog.ForLogProvider;
import com.xdja.safekeyservice.forlog.error.ErrorBean;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <br>author: wzg@xdja.com <br/>
 * date:   2018/5/4 14:35 <br/>
 */

public class LogcatUtils {
    private static String tag = "LogUtils";
    private static String logFileDirectory;
    private static String xlogFileDirectory;


    private static DateFormat formatter = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private static final long DAY_TIME_3 = 3 * 3600 * 24 * 1000;
    private static final long DAY_TIME_2 = 2 * 3600 * 24 * 1000;
    private static final String LOG_ZIP_NAME = "chipManagerShell.zip";
    private static final long UPLOAD_LOG_MAX_SIZE = 10 * 1024 * 1024;


    public static String getLogFileDirectory(){
        if (TextUtils.isEmpty(logFileDirectory)){
           logFileDirectory =  ForLogProvider.getStaticContext().getExternalFilesDir("xdjalog/soc").getAbsolutePath();
        }
        Log.e("test","logFileDirectory = " + logFileDirectory);
        return logFileDirectory;
    }

    public static String getXlogFileDirectory(){
        if (TextUtils.isEmpty(xlogFileDirectory)){
            xlogFileDirectory = ForLogProvider.getStaticContext().getExternalFilesDir("/xdjalog/soc/xlog").getAbsolutePath();
        }
        return xlogFileDirectory;
    }

    public static void startLogcat2File() {
        List<String> commandList = new ArrayList<>();

        File logFileDirectoryFile = new File(getLogFileDirectory());
        if(!logFileDirectoryFile.exists()){
            boolean mkdirsRes = logFileDirectoryFile.mkdirs();

            Log.w(tag, "mkdirsRes: " + mkdirsRes);

        }

        String rm2FileCmdStr = "rm -r " + getLogFilePath();
        String logcat2FileCmdStr = "logcat -v time -f " + getLogFilePath();


        commandList.add(rm2FileCmdStr);
        commandList.add(logcat2FileCmdStr);
/*
     commandList.add("rm -r /sdcard/logcat-2.log");
     commandList.add("logcat time -f /sdcard/logcat-2.log");
*/
        Log.d(tag, "before ShellUtils.execCommand");

        ShellUtils.execCommand(commandList, false);

        Log.d(tag, "after ShellUtils.execCommand");

    }


    private static String getLogFilePath() {
        long timestamp = System.currentTimeMillis();
        String time = formatter.format(new Date());

        return getLogFileDirectory() + "/log-" + time + "-" + timestamp + ".log";
    }

    //add 2019年9月25日19:51:39 weizg 删除日志缓存路径下，最后编辑日期是当前日期三天前的日志文件
    public static void autoDelOlderLogFile() {

        Log.w(tag, "autoDelOlderLogFile");

        File logFileDirectoryFile = new File(getLogFileDirectory());

        if (!logFileDirectoryFile.exists()) {
            Log.w(tag, "no need del log file");
            return;
        }

        File[] logFiles = logFileDirectoryFile.listFiles();
        if (logFiles == null || logFiles.length <= 0) {
            Log.w(tag, "logFiles null or len zero");
            return;
        }

        for (File logFile : logFiles) {

            if (logFile.isFile() && isNeedDel(logFile)) {

                try {
                    boolean delete = logFile.delete();
//                    Log.w(tag, logFile.getName() + " delete ret " + delete);
                }catch (Exception e){
                    e.printStackTrace();
                }
            }
        }
    }

    private static boolean isNeedDel(File logFile) {
        //日志文件的最后编辑时间在三天前的，需要删除
        long needDelTime = System.currentTimeMillis() - DAY_TIME_3;

        return logFile.lastModified() < needDelTime;

    }

    //按照策略压缩日志文件； pair.first执行结果，pair.second压缩后文件路径
    public static Pair<Integer, String> zipNeedUploadLogFiles(){
        File logFileDirectoryFile = new File(getLogFileDirectory());

        if (!logFileDirectoryFile.exists()) {
            Log.w(tag, "log direct not exist");
            return Pair.create(ErrorBean.code_log_direct_not_exist,"");
        }

        File[] logFiles = logFileDirectoryFile.listFiles();
        if (logFiles == null || logFiles.length <= 0) {
            Log.w(tag, "logFiles null or len zero");
            return Pair.create(ErrorBean.code_log_file_not_exist,"");
        }

        List<File> needUploadFiles = new ArrayList<>(8);

        long currentTime = System.currentTimeMillis();
        for (File logFile : logFiles) {

            long lastModifiedTime = logFile.lastModified();
            if (logFile.isFile() && logFile.getName().contains(".log")
                    && (currentTime - lastModifiedTime < DAY_TIME_2)) {
                needUploadFiles.add(logFile);
            }

        }

        if(needUploadFiles.size() <= 0){
            return Pair.create(ErrorBean.code_log_not_exist_need_upload,"");
        }

        //压缩文件
        String zipLogFilePath = getLogFileDirectory() + "/" + LOG_ZIP_NAME;
        int zipRet = ZipUtils.zip(needUploadFiles, new File(zipLogFilePath));

        if(zipRet == 0){
            if (new File(zipLogFilePath).length() > UPLOAD_LOG_MAX_SIZE) {
                return Pair.create(ErrorBean.code_log_file_size_too_large, zipLogFilePath);
            }
        }

        return Pair.create(zipRet, zipLogFilePath);
    }

    public static long maxUploadLogFileSize(){
        return UPLOAD_LOG_MAX_SIZE/(1024*1024);
    }
}
