package com.xdja.safekeyservice.forlog.utils;

import org.zeroturnaround.zip.ZipUtil;

import java.io.File;
import java.util.List;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2019/9/29 <br/>
 */
public class ZipUtils {

    /**
     * 压缩
     *
     * @param srcFileList 要压缩文件路径的list
     * @param objZipFile  压缩后文件路径
     * @return 0：成功；其他：失败；
     */
    public static int zip(List<File> srcFileList, File objZipFile) {
        try {
            File[] files = (File[]) srcFileList.toArray();
            ZipUtil.packEntries(files, objZipFile);
            return 0;
        } catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }
}
