/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safekeyservice.jsserverckms;

import android.content.Context;
import android.text.TextUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class AppIdTokenCacheUtils {
    public static void putToken(Context context, String appId, String token) {
        if (context == null) {
            throw new NullPointerException("Context is null!");
        }
        if (TextUtils.isEmpty((CharSequence)appId) || TextUtils.isEmpty((CharSequence)token)) {
            return;
        }
        String key = AppIdTokenCacheUtils.converKey(appId);
        try {
            FileOutputStream fos = context.openFileOutput(key, 0);
            fos.write(token.getBytes());
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getToken(Context context, String appId) {
        if (context == null) {
            throw new NullPointerException("Context is null!");
        }
        if (TextUtils.isEmpty((CharSequence)appId)) {
            return "";
        }
        String key = AppIdTokenCacheUtils.converKey(appId);
        try {
            int len;
            FileInputStream fis = context.openFileInput(key);
            byte[] buffer = new byte[1024];
            StringBuilder sb = new StringBuilder();
            while ((len = fis.read(buffer)) > 0) {
                String tmp = new String(buffer, 0, len);
                sb.append(tmp);
            }
            return sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String converKey(String appId) {
        String key = appId.hashCode() + "";
        key = key.replace("-", "_");
        return key;
    }
}

