/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safekeyservice.jsserverckms;

import android.content.Context;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.xdja.safekeyservice.jarv2.js.JsCkmsEntityManager;
import com.xdja.safekeyservice.jarv2.js.JsCkmsGroupManager;
import com.xdja.safekeyservice.jarv2.js.JsCkmsSdkManager;
import com.xdja.safekeyservice.jsserverckms.AppIdTokenCacheUtils;
import com.xdja.scservice_domain.modules.ClientToken;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CkmsObjManager {
    private static CkmsObjManager instance;
    private Context context;
    private ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();
    private HashMap<String, JsCkmsSdkManager> ckmsManagerMap = new HashMap();
    private HashMap<String, JsCkmsEntityManager> entityManagerMap = new HashMap();
    private HashMap<String, JsCkmsGroupManager> groupManagerMap = new HashMap();
    private HashMap<String, String> appIdTokenMap = new HashMap();

    private CkmsObjManager(Context context) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CkmsObjManager getInstance(Context context) {
        if (instance != null) return instance;
        Class<CkmsObjManager> clazz = CkmsObjManager.class;
        synchronized (CkmsObjManager.class) {
            if (context == null) {
                throw new NullPointerException("Context is null!");
            }
            if (instance != null) return instance;
            instance = new CkmsObjManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public JsCkmsSdkManager getJsCkmsSdkManagerByToken(String token) {
        if (TextUtils.isEmpty((CharSequence)token)) {
            return null;
        }
        ClientToken clientToken = (ClientToken)new Gson().fromJson(token, ClientToken.class);
        String appId = clientToken.getToken_data().getAppId();
        if (TextUtils.isEmpty((CharSequence)appId)) {
            return null;
        }
        this.makeManagerByToken(token);
        return this.ckmsManagerMap.get(appId);
    }

    public JsCkmsSdkManager getJsCkmsSdkManager(String appId) {
        JsCkmsSdkManager manager = this.ckmsManagerMap.get(appId);
        if (manager != null) {
            return manager;
        }
        String token = this.getToken(appId);
        if (token == null) {
            return null;
        }
        this.makeManagerByToken(token);
        manager = this.ckmsManagerMap.get(appId);
        return manager;
    }

    public JsCkmsEntityManager getJsCkmsEntityManager(String appId) {
        JsCkmsEntityManager manager = this.entityManagerMap.get(appId);
        if (manager != null) {
            return manager;
        }
        String token = this.getToken(appId);
        if (token == null) {
            return null;
        }
        this.makeManagerByToken(token);
        manager = this.entityManagerMap.get(appId);
        return manager;
    }

    public JsCkmsGroupManager getJsCkmsGroupManager(String appId) {
        JsCkmsGroupManager manager = this.groupManagerMap.get(appId);
        if (manager != null) {
            return manager;
        }
        String token = this.getToken(appId);
        if (token == null) {
            return null;
        }
        this.makeManagerByToken(token);
        manager = this.groupManagerMap.get(appId);
        return manager;
    }

    private void makeManagerByToken(String token) {
        if (TextUtils.isEmpty((CharSequence)token)) {
            throw new NullPointerException("Token is null");
        }
        ClientToken clientToken = (ClientToken)new Gson().fromJson(token, ClientToken.class);
        String appId = clientToken.getToken_data().getAppId();
        if (this.appIdTokenMap.containsKey(appId) && !this.appIdTokenMap.get(appId).equals(token)) {
            this.clearAppIdInMap(appId);
        }
        if (!this.appIdTokenMap.containsKey(appId)) {
            this.appIdTokenMap.put(appId, token);
        }
        if (!this.ckmsManagerMap.containsKey(appId)) {
            JsCkmsSdkManager ckmsManager = new JsCkmsSdkManager(this.context, clientToken);
            this.ckmsManagerMap.put(appId, ckmsManager);
        }
        if (!this.entityManagerMap.containsKey(appId)) {
            JsCkmsEntityManager entityManager = new JsCkmsEntityManager(this.context, clientToken);
            this.entityManagerMap.put(appId, entityManager);
        }
        if (!this.groupManagerMap.containsKey(appId)) {
            JsCkmsGroupManager groupManager = new JsCkmsGroupManager(this.context, clientToken);
            this.groupManagerMap.put(appId, groupManager);
        }
        this.cachedAppIdAndClientToken(appId, token);
    }

    private String getToken(String appId) {
        String token = AppIdTokenCacheUtils.getToken(this.context, appId);
        return token;
    }

    private void cachedAppIdAndClientToken(final String appId, final String token) {
        this.singleThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                AppIdTokenCacheUtils.putToken(CkmsObjManager.this.context, appId, token);
            }
        });
    }

    private void clearAppIdInMap(String appId) {
        this.ckmsManagerMap.remove(appId);
        this.groupManagerMap.remove(appId);
        this.entityManagerMap.remove(appId);
        this.appIdTokenMap.remove(appId);
    }
}

