/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safekeyservice.jsserverckms;

import android.content.Context;
import android.util.Log;
import com.google.gson.Gson;
import com.xdja.safekeyservice.jarv2.SecuritySDKManager;
import com.xdja.safekeyservice.jarv2.bean.IVerifyPinResult;
import com.xdja.safekeyservice.jarv2.js.JsCkmsEntityManager;
import com.xdja.safekeyservice.jarv2.js.JsCkmsGroupManager;
import com.xdja.safekeyservice.jarv2.js.JsCkmsSdkManager;
import com.xdja.safekeyservice.jsserverckms.CkmsObjManager;
import com.xdja.safekeyservice.jsserverckms.bean.GetChallengeRequestBean;
import com.xdja.safekeyservice.jsserverckms.bean.InitRequestBean;
import com.xdja.safekeyservice.jsserverckms.bean.request.AddDeviceForciblyRequest;
import com.xdja.safekeyservice.jsserverckms.bean.request.AddDeviceRequest;
import com.xdja.safekeyservice.jsserverckms.bean.request.AddEntitiesRequestBean;
import com.xdja.safekeyservice.jsserverckms.bean.request.BaseRequestBean;
import com.xdja.safekeyservice.jsserverckms.bean.request.CheckAddingDeviceReqBean;
import com.xdja.safekeyservice.jsserverckms.bean.request.CreateEntityRequest;
import com.xdja.safekeyservice.jsserverckms.bean.request.CreateGroupRequestBean;
import com.xdja.safekeyservice.jsserverckms.bean.request.DecryptDataRequestBean;
import com.xdja.safekeyservice.jsserverckms.bean.request.DestroyEntityRequestBean;
import com.xdja.safekeyservice.jsserverckms.bean.request.DestroyGroupRequestBean;
import com.xdja.safekeyservice.jsserverckms.bean.request.EncryptDataRequestBean;
import com.xdja.safekeyservice.jsserverckms.bean.request.GetAddingDeviceRequestBean;
import com.xdja.safekeyservice.jsserverckms.bean.request.GetDeviceIDRequest;
import com.xdja.safekeyservice.jsserverckms.bean.request.GetDevicesRequestBean;
import com.xdja.safekeyservice.jsserverckms.bean.request.GetEntitiesRequest;
import com.xdja.safekeyservice.jsserverckms.bean.request.GetEntityRequestBean;
import com.xdja.safekeyservice.jsserverckms.bean.request.GetGroupRequestBean;
import com.xdja.safekeyservice.jsserverckms.bean.request.GetStatusRequestBean;
import com.xdja.safekeyservice.jsserverckms.bean.request.GetSyncPowerRequestBean;
import com.xdja.safekeyservice.jsserverckms.bean.request.IsDevInEntityRequestBean;
import com.xdja.safekeyservice.jsserverckms.bean.request.JudgeIsEncryptDataRequest;
import com.xdja.safekeyservice.jsserverckms.bean.request.RefreshRequestBean;
import com.xdja.safekeyservice.jsserverckms.bean.request.RemoveDeviceRequest;
import com.xdja.safekeyservice.jsserverckms.bean.request.RemoveEntitiesRequestBean;
import com.xdja.safekeyservice.jsserverckms.bean.request.SyncSecPowerRequest;
import com.xdja.safekeyservice.jsserverckms.bean.response.BaseResponse;
import com.xdja.safekeyservice.jsserverckms.bean.response.ByteDataResponse;
import com.xdja.safekeyservice.jsserverckms.bean.response.ErrorResponse;
import com.xdja.scservice_domain.encrypt.PlainDataBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.json.JSONObject;

public class CkmsOperate {
    public static final String TAG = "CardsOperateTag";
    private static CkmsOperate instance;
    private Context context;
    private JsCkmsEntityManager manager;

    private CkmsOperate(Context context) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CkmsOperate getInstance(Context context) {
        if (instance != null) return instance;
        Class<CkmsOperate> clazz = CkmsOperate.class;
        synchronized (CkmsOperate.class) {
            if (instance != null) return instance;
            if (context == null) {
                throw new NullPointerException("Context is null.");
            }
            instance = new CkmsOperate(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public String encryptData(String args) {
        Gson gson = new Gson();
        EncryptDataRequestBean encryptDataRequestBean = (EncryptDataRequestBean)gson.fromJson(args, EncryptDataRequestBean.class);
        String appId = encryptDataRequestBean.appId;
        JsCkmsSdkManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsSdkManager(appId);
        if (manager == null) {
            Log.w((String)"CKMS_JS", (String)"encryptData manager null ");
            return this.getManagerNullErrorBean(gson);
        }
        try {
            int encType = (int)encryptDataRequestBean.nType;
            if (encryptDataRequestBean.nType == 1L) {
                encType = -28770;
            } else if (encryptDataRequestBean.nType == 2L) {
                encType = -28754;
            }
            byte[] encryptData = manager.encryptData(encryptDataRequestBean.entity, encryptDataRequestBean.sGroupID, encType, encryptDataRequestBean.dataInBytes);
            ByteDataResponse byteDataResponse = new ByteDataResponse();
            byteDataResponse.data = encryptData;
            BaseResponse baseResponse = new BaseResponse();
            baseResponse.ret_code = 0;
            baseResponse.result = byteDataResponse;
            return gson.toJson((Object)baseResponse);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public String decryptData(String args) {
        Gson gson = new Gson();
        DecryptDataRequestBean decryptDataRequestBean = (DecryptDataRequestBean)gson.fromJson(args, DecryptDataRequestBean.class);
        String appId = decryptDataRequestBean.appId;
        JsCkmsSdkManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsSdkManager(appId);
        if (manager == null) {
            Log.w((String)"CKMS_JS", (String)"decryptData manager null ");
            return this.getManagerNullErrorBean(gson);
        }
        try {
            ByteDataResponse byteDataResponse = new ByteDataResponse();
            PlainDataBean plainDataBean = manager.decryptData(decryptDataRequestBean.entity, decryptDataRequestBean.cipherData);
            BaseResponse baseResponse = new BaseResponse();
            baseResponse.ret_code = 0;
            baseResponse.result = plainDataBean;
            return gson.toJson((Object)baseResponse);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public String judgeIsEncryptData(String args) {
        Log.w((String)"CKMS_JS", (String)("judgeIsEncryptData args: " + args));
        Gson gson = new Gson();
        JudgeIsEncryptDataRequest judgeIsEncryptDataRequest = (JudgeIsEncryptDataRequest)gson.fromJson(args, JudgeIsEncryptDataRequest.class);
        try {
            int dataType = SecuritySDKManager.getInstance().judgeIsEncryptData(this.context, judgeIsEncryptDataRequest.dataInBytes);
            BaseResponse baseResponse = new BaseResponse();
            baseResponse.ret_code = 0;
            baseResponse.result = dataType == -28770 ? Integer.valueOf(1) : (dataType == -28754 ? Integer.valueOf(2) : Integer.valueOf(dataType));
            return gson.toJson((Object)baseResponse);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public String verifyPIN(String arg) {
        final int[] resCode = new int[]{-1};
        final CountDownLatch latch = new CountDownLatch(1);
        SecuritySDKManager.getInstance().startVerifyPinActivity(this.context, new IVerifyPinResult(){

            public void onResult(int result, String msg) {
                resCode[0] = result;
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.ret_code = resCode[0];
        return new Gson().toJson((Object)errorResponse);
    }

    public String getChallenge(String arg) {
        Log.w((String)"CKMS_JS", (String)("getChallenge args: " + arg));
        SecuritySDKManager.getInstance().getStatus(this.context, 12);
        Gson gson = new Gson();
        GetChallengeRequestBean getChallengeRequestBean = (GetChallengeRequestBean)gson.fromJson(arg, GetChallengeRequestBean.class);
        String token = gson.toJson((Object)getChallengeRequestBean.token);
        JsCkmsSdkManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsSdkManagerByToken(token);
        JSONObject resJsonObject = manager.getChallenge(this.context);
        return resJsonObject.toString();
    }

    public String init(String args) {
        Log.w((String)"CKMS_JS", (String)("init args: " + args));
        Gson gson = new Gson();
        InitRequestBean initRequestBean = (InitRequestBean)gson.fromJson(args, InitRequestBean.class);
        String appId = initRequestBean.appId;
        JsCkmsSdkManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsSdkManager(appId);
        if (manager == null) {
            Log.w((String)"CKMS_JS", (String)"init manager null ");
            return this.getManagerNullErrorBean(gson);
        }
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.ret_code = 51002;
        errorResponse.err_msg = "\u521d\u59cb\u5316\u5931\u8d25\uff0c\u63a5\u53e3\u6ca1\u6709\u8fd4\u56de";
        final String[] initRes = new String[]{gson.toJson((Object)errorResponse)};
        final CountDownLatch latch = new CountDownLatch(1);
        manager.init(this.context, initRequestBean.signatureOfChallenge, new SecuritySDKManager.InitCallBack(){

            public void onInitComplete(JSONObject result) {
                initRes[0] = result.toString();
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return initRes[0];
    }

    public String getStatus(String arg) {
        Log.w((String)"CKMS_JS", (String)("getStatus args: " + arg));
        Gson gson = new Gson();
        GetStatusRequestBean getStatusRequestBean = (GetStatusRequestBean)gson.fromJson(arg, GetStatusRequestBean.class);
        JSONObject resJsonObject = SecuritySDKManager.getInstance().getStatus(this.context, getStatusRequestBean.flag);
        return resJsonObject.toString();
    }

    public String refresh(String arg) {
        Log.w((String)"CKMS_JS", (String)("refresh args: " + arg));
        Gson gson = new Gson();
        RefreshRequestBean refreshRequestBean = (RefreshRequestBean)gson.fromJson(arg, RefreshRequestBean.class);
        JsCkmsSdkManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsSdkManager(refreshRequestBean.appId);
        if (manager == null) {
            Log.w((String)"CKMS_JS", (String)"refresh manager null ");
            return this.getManagerNullErrorBean(gson);
        }
        JSONObject resJsonObject = manager.refresh();
        return resJsonObject.toString();
    }

    private String getManagerNullErrorBean(Gson gson) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.ret_code = 51001;
        errorResponse.err_msg = "\u4e1a\u52a1\u64cd\u4f5c\u7c7b\u521d\u59cb\u5316\u5931\u8d25";
        return gson.toJson((Object)errorResponse);
    }

    public String release(String arg) {
        Log.w((String)"CKMS_JS", (String)("release args: " + arg));
        Gson gson = new Gson();
        BaseRequestBean baseRequestBean = (BaseRequestBean)gson.fromJson(arg, BaseRequestBean.class);
        JsCkmsSdkManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsSdkManager(baseRequestBean.appId);
        if (manager == null) {
            Log.w((String)"CKMS_JS", (String)"release manager null ");
            return this.getManagerNullErrorBean(gson);
        }
        JSONObject resJsonObject = manager.release();
        return resJsonObject.toString();
    }

    public String isCurrentDevAdd2entity(String args) {
        Gson gson = new Gson();
        IsDevInEntityRequestBean isDevInEntityRequestBean = (IsDevInEntityRequestBean)gson.fromJson(args, IsDevInEntityRequestBean.class);
        JsCkmsEntityManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsEntityManager(isDevInEntityRequestBean.appId);
        if (manager == null) {
            Log.w((String)"CKMS_JS", (String)"isCurrentDevAdd2entity manager null ");
            return this.getManagerNullErrorBean(gson);
        }
        JSONObject currentDevAdded2Entity = manager.isCurrentDevAdded2Entity(isDevInEntityRequestBean.entity);
        return currentDevAdded2Entity.toString();
    }

    public String getDevices(String args) {
        Gson gson = new Gson();
        GetDevicesRequestBean getDevicesRequestBean = (GetDevicesRequestBean)gson.fromJson(args, GetDevicesRequestBean.class);
        JsCkmsEntityManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsEntityManager(getDevicesRequestBean.appId);
        if (manager == null) {
            Log.w((String)"CKMS_JS", (String)"isCurrentDevAdd2entity manager null ");
            return this.getManagerNullErrorBean(gson);
        }
        List<String> entityList = Arrays.asList(getDevicesRequestBean.entities);
        ArrayList<String> entities = new ArrayList<String>(entityList);
        JSONObject currentDevAdded2Entity = manager.getDevices(entities);
        return currentDevAdded2Entity.toString();
    }

    public String destroy(String args) {
        Gson gson = new Gson();
        DestroyEntityRequestBean destroyEntityRequestBean = (DestroyEntityRequestBean)gson.fromJson(args, DestroyEntityRequestBean.class);
        JsCkmsEntityManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsEntityManager(destroyEntityRequestBean.appId);
        if (manager == null) {
            Log.w((String)"CKMS_JS", (String)"destroyEntity manager null ");
            return this.getManagerNullErrorBean(gson);
        }
        JSONObject destroyRes = manager.destroy(destroyEntityRequestBean.entity, destroyEntityRequestBean.operSignature);
        return destroyRes.toString();
    }

    public String createGroup(String args) {
        Gson gson = new Gson();
        CreateGroupRequestBean createGroupRequestBean = (CreateGroupRequestBean)gson.fromJson(args, CreateGroupRequestBean.class);
        JsCkmsGroupManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsGroupManager(createGroupRequestBean.appId);
        if (manager == null) {
            Log.w((String)"CKMS_JS", (String)"createGroup manager null ");
            return this.getManagerNullErrorBean(gson);
        }
        List<String> entityList = Arrays.asList(createGroupRequestBean.entities);
        ArrayList<String> entities = new ArrayList<String>(entityList);
        JSONObject createGroupRes = manager.createSGroup(createGroupRequestBean.currentEntity, createGroupRequestBean.sGroupID, entities, createGroupRequestBean.operSignature);
        return createGroupRes.toString();
    }

    public String addEntities(String args) {
        Gson gson = new Gson();
        AddEntitiesRequestBean addEntitiesRequestBean = (AddEntitiesRequestBean)gson.fromJson(args, AddEntitiesRequestBean.class);
        JsCkmsGroupManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsGroupManager(addEntitiesRequestBean.appId);
        if (manager == null) {
            Log.w((String)"CKMS_JS", (String)"addEntities manager null ");
            return this.getManagerNullErrorBean(gson);
        }
        List<String> entityList = Arrays.asList(addEntitiesRequestBean.entities4Add);
        ArrayList<String> entities = new ArrayList<String>(entityList);
        JSONObject addEntityRes = manager.addEntities(addEntitiesRequestBean.currentEntity, entities, addEntitiesRequestBean.sGroupID, addEntitiesRequestBean.operSignature);
        return addEntityRes.toString();
    }

    public String removeEntities(String args) {
        Gson gson = new Gson();
        RemoveEntitiesRequestBean removeEntitiesRequestBean = (RemoveEntitiesRequestBean)gson.fromJson(args, RemoveEntitiesRequestBean.class);
        JsCkmsGroupManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsGroupManager(removeEntitiesRequestBean.appId);
        if (manager == null) {
            Log.w((String)"CKMS_JS", (String)"removeEntities manager null ");
            return this.getManagerNullErrorBean(gson);
        }
        List<String> entityList = Arrays.asList(removeEntitiesRequestBean.entities4Remove);
        ArrayList<String> entities = new ArrayList<String>(entityList);
        JSONObject removeEntityRes = manager.removeEntities(removeEntitiesRequestBean.currentEntity, entities, removeEntitiesRequestBean.sGroupID, removeEntitiesRequestBean.operSignature);
        return removeEntityRes.toString();
    }

    public String getEntitiesInGroup(String args) {
        Gson gson = new Gson();
        GetEntityRequestBean getEntityRequestBean = (GetEntityRequestBean)gson.fromJson(args, GetEntityRequestBean.class);
        JsCkmsGroupManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsGroupManager(getEntityRequestBean.appId);
        if (manager == null) {
            Log.w((String)"CKMS_JS", (String)"getEntities manager null ");
            return this.getManagerNullErrorBean(gson);
        }
        JSONObject getEntitiesRes = manager.getEntities(getEntityRequestBean.sGroupID);
        return getEntitiesRes.toString();
    }

    public String getGroups(String args) {
        Gson gson = new Gson();
        GetGroupRequestBean getGroupRequestBean = (GetGroupRequestBean)gson.fromJson(args, GetGroupRequestBean.class);
        JsCkmsGroupManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsGroupManager(getGroupRequestBean.appId);
        if (manager == null) {
            Log.w((String)"CKMS_JS", (String)"getGroups manager null ");
            return this.getManagerNullErrorBean(gson);
        }
        List<String> entityList = Arrays.asList(getGroupRequestBean.entities);
        ArrayList<String> entities = new ArrayList<String>(entityList);
        JSONObject getGroupsRes = manager.getSGroups(entities);
        return getGroupsRes.toString();
    }

    public String destroyGroup(String args) {
        Gson gson = new Gson();
        DestroyGroupRequestBean destroyGroupRequestBean = (DestroyGroupRequestBean)gson.fromJson(args, DestroyGroupRequestBean.class);
        JsCkmsGroupManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsGroupManager(destroyGroupRequestBean.appId);
        if (manager == null) {
            Log.w((String)"CKMS_JS", (String)"destroyGroup manager null ");
            return this.getManagerNullErrorBean(gson);
        }
        JSONObject destroyGroupRes = manager.destroy(destroyGroupRequestBean.currentEntity, destroyGroupRequestBean.sGroupID, destroyGroupRequestBean.operSignature);
        return destroyGroupRes.toString();
    }

    public String create(String arg) {
        Gson gson = new Gson();
        CreateEntityRequest createEntityRequest = (CreateEntityRequest)gson.fromJson(arg, CreateEntityRequest.class);
        JsCkmsEntityManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsEntityManager(createEntityRequest.appId);
        JSONObject jsonObject = manager.create(createEntityRequest.entity, createEntityRequest.operSignature);
        return jsonObject.toString();
    }

    public String getEntities(String arg) {
        Gson gson = new Gson();
        GetEntitiesRequest getChallengeRequestBean = (GetEntitiesRequest)gson.fromJson(arg, GetEntitiesRequest.class);
        JsCkmsEntityManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsEntityManager(getChallengeRequestBean.appId);
        return manager.getEntities(getChallengeRequestBean.cardIDs).toString();
    }

    public String addDeviceForcibly(String arg) {
        Gson gson = new Gson();
        AddDeviceForciblyRequest addDeviceForciblyRequest = (AddDeviceForciblyRequest)gson.fromJson(arg, AddDeviceForciblyRequest.class);
        JsCkmsEntityManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsEntityManager(addDeviceForciblyRequest.appId);
        return manager.addDeviceForcibly(addDeviceForciblyRequest.entity, addDeviceForciblyRequest.operSignature).toString();
    }

    public String getAddingDeviceRequest(String arg) {
        Gson gson = new Gson();
        GetAddingDeviceRequestBean getAddingDeviceRequestBean = (GetAddingDeviceRequestBean)gson.fromJson(arg, GetAddingDeviceRequestBean.class);
        JsCkmsEntityManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsEntityManager(getAddingDeviceRequestBean.appId);
        return manager.getAddingDeviceRequest(getAddingDeviceRequestBean.entity).toString();
    }

    public String checkAddingDeviceReq(String arg) {
        Gson gson = new Gson();
        CheckAddingDeviceReqBean checkAddingDeviceReqBean = (CheckAddingDeviceReqBean)gson.fromJson(arg, CheckAddingDeviceReqBean.class);
        JsCkmsEntityManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsEntityManager(checkAddingDeviceReqBean.appId);
        return manager.checkAddingDeviceReq(checkAddingDeviceReqBean.addingDevReqId).toString();
    }

    public String addDevice(String arg) {
        Gson gson = new Gson();
        AddDeviceRequest addDeviceRequest = (AddDeviceRequest)gson.fromJson(arg, AddDeviceRequest.class);
        JsCkmsEntityManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsEntityManager(addDeviceRequest.appId);
        return manager.addDevice(addDeviceRequest.entity, addDeviceRequest.addingDevReqId, addDeviceRequest.operSignature).toString();
    }

    public String removeDevice(String arg) {
        Gson gson = new Gson();
        RemoveDeviceRequest removeDeviceRequest = (RemoveDeviceRequest)gson.fromJson(arg, RemoveDeviceRequest.class);
        JsCkmsEntityManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsEntityManager(removeDeviceRequest.appId);
        return manager.removeDevice(removeDeviceRequest.entity, removeDeviceRequest.deviceID, removeDeviceRequest.operSignature).toString();
    }

    public String getSyncPowerRequest(String arg) {
        Gson gson = new Gson();
        GetSyncPowerRequestBean getSyncPowerRequestBean = (GetSyncPowerRequestBean)gson.fromJson(arg, GetSyncPowerRequestBean.class);
        JsCkmsEntityManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsEntityManager(getSyncPowerRequestBean.appId);
        return manager.getSyncPowerRequest(getSyncPowerRequestBean.entity).toString();
    }

    public String syncSecPower(String arg) {
        Gson gson = new Gson();
        SyncSecPowerRequest syncSecPowerRequest = (SyncSecPowerRequest)gson.fromJson(arg, SyncSecPowerRequest.class);
        JsCkmsEntityManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsEntityManager(syncSecPowerRequest.appId);
        return manager.syncSecPower(syncSecPowerRequest.entity, syncSecPowerRequest.syncPowerReqId, syncSecPowerRequest.operSignature).toString();
    }

    public String getDeviceID(String arg) {
        Gson gson = new Gson();
        GetDeviceIDRequest getDeviceIDRequest = (GetDeviceIDRequest)gson.fromJson(arg, GetDeviceIDRequest.class);
        JsCkmsEntityManager manager = CkmsObjManager.getInstance(this.context).getJsCkmsEntityManager(getDeviceIDRequest.appId);
        return manager.getDeviceID().toString();
    }
}

